/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.common.frameworks.internal.FlexibleJavaProjectPreferenceUtil;

public class UpdateProjectClasspath {
    public UpdateProjectClasspath(String sourceFolder, String componentName, IProject jProject) {
        this.addSrcFolderToProject(sourceFolder, componentName, jProject);
    }

    private IClasspathEntry[] getClasspathEntries(String sourceFolder, String componentName, IProject jProject) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        list.add(JavaCore.newSourceEntry((IPath)jProject.getFullPath().append(sourceFolder)));
        IClasspathEntry[] classpath = new IClasspathEntry[list.size()];
        boolean isProjectMultiComponents = FlexibleJavaProjectPreferenceUtil.getMultipleModulesPerProjectProp();
        IPath newOutputPath = null;
        int i = 0;
        while (i < classpath.length) {
            classpath[i] = (IClasspathEntry)list.get(i);
            newOutputPath = isProjectMultiComponents ? Path.fromOSString((String)(String.valueOf('/') + jProject.getName() + "/bin/" + componentName + '/')) : Path.fromOSString((String)(String.valueOf('/') + jProject.getName() + "/bin/"));
            ((ClasspathEntry)classpath[i]).specificOutputLocation = newOutputPath;
            ++i;
        }
        return classpath;
    }

    private void addSrcFolderToProject(String sourceFolder, String componentName, IProject jProject) {
        IJavaProject javaProject = JavaCore.create((IProject)jProject);
        try {
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> oldEntriesList = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] newEntries = this.getClasspathEntries(sourceFolder, componentName, jProject);
            int oldSize = oldEntries.length;
            int newSize = newEntries.length;
            IClasspathEntry[] classpathEnties = new IClasspathEntry[oldSize + newSize];
            int k = 0;
            int i = 0;
            while (i < oldEntries.length) {
                classpathEnties[k] = oldEntries[i];
                oldEntriesList.add(oldEntries[i]);
                ++k;
                ++i;
            }
            int j = 0;
            while (j < newEntries.length) {
                if (!oldEntriesList.contains(newEntries[j])) {
                    classpathEnties[k] = newEntries[j];
                    ++k;
                }
                ++j;
            }
            javaProject.setRawClasspath(classpathEnties, null);
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }
}

