/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.earcreation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.J2EEEditModel;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.EARProjectMap;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModuleMapping;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModulemapPackage;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.wst.common.frameworks.internal.SaveFailedException;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;

public class EAREditModel
extends J2EEEditModel {
    private boolean stopListenerNotifications = false;
    public static final String MODULE_MAP_URI = "META-INF/.modulemaps";
    public static final URI MODULE_MAP_URI_OBJ = URI.createURI((String)"META-INF/.modulemaps");

    public EAREditModel(String editModelID, EMFWorkbenchContext context, boolean readOnly) {
        super(editModelID, context, readOnly);
    }

    public EAREditModel(String editModelID, EMFWorkbenchContext context, boolean readOnly, boolean accessUnkownResourcesAsReadOnly) {
        super(editModelID, context, readOnly, accessUnkownResourcesAsReadOnly);
    }

    public ModuleMapping addModuleMapping(Module module, IProject aProject) {
        ModuleMapping map = ((ModulemapPackage)EPackage.Registry.INSTANCE.getEPackage("modulemap.xmi")).getModulemapFactory().createModuleMapping();
        map.setModule(module);
        map.setProjectName(aProject.getName());
        this.getEARProjectMap().getMappings().add((Object)map);
        return map;
    }

    public UtilityJARMapping addUtilityJARMapping(String uri, IProject aProject) {
        UtilityJARMapping map = ((ModulemapPackage)EPackage.Registry.INSTANCE.getEPackage("modulemap.xmi")).getModulemapFactory().createUtilityJARMapping();
        map.setUri(uri);
        map.setProjectName(aProject.getName());
        this.getEARProjectMap().getUtilityJARMappings().add((Object)map);
        return map;
    }

    public Application getApplication() {
        ApplicationResource dd = this.getApplicationXmiResource();
        return dd == null ? null : dd.getApplication();
    }

    public ApplicationResource getApplicationXmiResource() {
        return (ApplicationResource)this.getResource(J2EEConstants.APPLICATION_DD_URI_OBJ);
    }

    public Set getModuleMappedProjects() {
        Set aSet = this.getModuleMappedModuleProjects();
        aSet.addAll(this.getModuleMappedUtilityJarProjects());
        return aSet;
    }

    public Map getModuleMappedProjectsAsMap() {
        Map aMap = this.getModuleMappedModuleProjectsAsMap();
        aMap.putAll(this.getModuleMappedUtilityJarProjectsAsMap());
        return aMap;
    }

    public Set getModuleMappedUtilityJarProjects() {
        HashSet aSet = new HashSet();
        aSet.addAll(this.getModuleMappedUtilityJarProjectsAsMap().values());
        return aSet;
    }

    public Map getModuleMappedUtilityJarProjectsAsMap() {
        HashMap<String, IProject> aMap = new HashMap<String, IProject>();
        IProject aProject = null;
        List utilityJARMappings = this.getUtilityJARMappings();
        int i = 0;
        while (i < utilityJARMappings.size()) {
            aProject = null;
            UtilityJARMapping map = (UtilityJARMapping)utilityJARMappings.get(i);
            if (map.getProjectName() != null && map.getProjectName().length() > 0) {
                aProject = this.getProject(map.getProjectName());
            }
            if (aProject != null && map.getUri() != null && map.getUri().length() > 0) {
                aMap.put(map.getUri(), aProject);
            }
            ++i;
        }
        return aMap;
    }

    public Set getModuleMappedModuleProjects() {
        HashSet aSet = new HashSet();
        aSet.addAll(this.getModuleMappedModuleProjectsAsMap().values());
        return aSet;
    }

    public Map getModuleMappedModuleProjectsAsMap() {
        HashMap<String, IProject> aMap = new HashMap<String, IProject>();
        List moduleMappings = this.getModuleMappings();
        IProject aProject = null;
        int i = 0;
        while (i < moduleMappings.size()) {
            aProject = null;
            ModuleMapping map = (ModuleMapping)moduleMappings.get(i);
            if (map.getProjectName() != null && map.getProjectName().length() > 0) {
                aProject = this.getProject(map.getProjectName());
            }
            Module module = map.getModule();
            if (aProject != null && module != null && module.getUri() != null && module.getUri().length() > 0) {
                aMap.put(module.getUri(), aProject);
            }
            ++i;
        }
        return aMap;
    }

    protected IProject getProject(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    protected IProject getProject(ModuleMapping mapping) {
        if (mapping != null && mapping.getProjectName() != null && mapping.getProjectName().length() > 0) {
            return this.getProject(mapping.getProjectName());
        }
        return null;
    }

    public UtilityJARMapping getUtilityJARMapping(String uri, IProject aProject) {
        if (aProject == null || uri == null) {
            return null;
        }
        List maps = this.getUtilityJARMappings();
        int i = 0;
        while (i < maps.size()) {
            UtilityJARMapping map = (UtilityJARMapping)maps.get(i);
            if (aProject.getName().equals(map.getProjectName()) && uri.equals(map.getUri())) {
                return map;
            }
            ++i;
        }
        return null;
    }

    public EARNatureRuntime getEARNature() {
        return EARNatureRuntime.getRuntime(this.getProject());
    }

    public EARProjectMap getEARProjectMap() {
        return this.getEARProjectMap(true);
    }

    protected EARProjectMap getEARProjectMap(boolean createIfEmpty) {
        Resource res = null;
        try {
            res = this.getOrCreateResource(MODULE_MAP_URI_OBJ);
        }
        catch (WrappedException wrappedException) {}
        if (res == null) {
            return null;
        }
        if (res.getContents().isEmpty() && createIfEmpty) {
            boolean dirtyFlag = res.isModified();
            res.getContents().add((Object)ModulemapPackage.eINSTANCE.getModulemapFactory().createEARProjectMap());
            res.setModified(dirtyFlag);
        }
        if (res.getContents().isEmpty()) {
            return null;
        }
        return (EARProjectMap)res.getContents().get(0);
    }

    public ModuleMapping getModuleMapping(Module module) {
        if (module == null) {
            return null;
        }
        List maps = this.getModuleMappings();
        int i = 0;
        while (i < maps.size()) {
            ModuleMapping map = (ModuleMapping)maps.get(i);
            Module iModule = map.getModule();
            if (module.equals(iModule)) {
                return map;
            }
            ++i;
        }
        return null;
    }

    public UtilityJARMapping getUtilityJARMapping(String uri) {
        if (uri == null) {
            return null;
        }
        List maps = this.getUtilityJARMappings();
        int i = 0;
        while (i < maps.size()) {
            UtilityJARMapping map = (UtilityJARMapping)maps.get(i);
            if (uri.equals(map.getUri())) {
                return map;
            }
            ++i;
        }
        return null;
    }

    public IProject getMappedProject(String uri) {
        UtilityJARMapping utilMapping = this.getUtilityJARMapping(uri);
        if (utilMapping != null) {
            return this.getProject(utilMapping.getProjectName());
        }
        List moduleMappings = this.getModuleMappings();
        int i = 0;
        while (i < moduleMappings.size()) {
            ModuleMapping map = (ModuleMapping)moduleMappings.get(i);
            Module mod = map.getModule();
            if (mod != null && uri.equals(mod.getUri())) {
                return this.getProject(map.getProjectName());
            }
            ++i;
        }
        return null;
    }

    public ModuleMapping getModuleMapping(IProject aProject) {
        if (aProject == null) {
            return null;
        }
        List maps = this.getModuleMappings();
        int i = 0;
        while (i < maps.size()) {
            ModuleMapping map = (ModuleMapping)maps.get(i);
            if (aProject.getName().equals(map.getProjectName())) {
                return map;
            }
            ++i;
        }
        return null;
    }

    public boolean uriExists(String currentName) {
        if (currentName != null) {
            return this.moduleMappingExists(currentName) || this.utilJarMappingExists(currentName);
        }
        return false;
    }

    public boolean moduleMappingExists(String currentUri) {
        if (currentUri == null) {
            return false;
        }
        List maps = this.getModuleMappings();
        if (maps != null || !maps.isEmpty()) {
            int i = 0;
            while (i < maps.size()) {
                ModuleMapping map = (ModuleMapping)maps.get(i);
                if (currentUri.equals(map.getModule().getUri())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean utilJarMappingExists(String currentUri) {
        if (currentUri == null) {
            return false;
        }
        List utilMaps = this.getUtilityJARMappings();
        if (utilMaps != null || !utilMaps.isEmpty()) {
            int i = 0;
            while (i < utilMaps.size()) {
                UtilityJARMapping utilMap = (UtilityJARMapping)utilMaps.get(i);
                if (currentUri.equals(utilMap.getUri())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public UtilityJARMapping getUtilityJARMapping(IProject aProject) {
        if (aProject == null) {
            return null;
        }
        List maps = this.getUtilityJARMappings();
        int i = 0;
        while (i < maps.size()) {
            UtilityJARMapping map = (UtilityJARMapping)maps.get(i);
            if (aProject.getName().equals(map.getProjectName())) {
                return map;
            }
            ++i;
        }
        return null;
    }

    public List getModuleMappings() {
        EARProjectMap map = this.getEARProjectMap();
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return map.getMappings();
    }

    public List getUtilityJARMappings() {
        EARProjectMap map = this.getEARProjectMap();
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return map.getUtilityJARMappings();
    }

    protected Resource getModuleMapsXmiResource() {
        return this.getResource(MODULE_MAP_URI_OBJ);
    }

    public Resource makeDeploymentDescriptorWithRoot() {
        XMLResource res = (XMLResource)this.makeEarXmiResource();
        Application app = ApplicationPackage.eINSTANCE.getApplicationFactory().createApplication();
        res.getContents().add((Object)app);
        res.setID((EObject)app, "Application_ID");
        res.setJ2EEVersionID(this.getEARNature().getJ2EEVersion());
        app.setDisplayName(this.getProject().getName());
        return res;
    }

    public Resource makeEarXmiResource() {
        return this.createResource(J2EEConstants.APPLICATION_DD_URI_OBJ);
    }

    protected Resource makeModuleMapsXmiResource() {
        if (this.isReadOnly()) {
            return null;
        }
        Resource res = this.createResource(MODULE_MAP_URI_OBJ);
        EARProjectMap root = ModulemapPackage.eINSTANCE.getModulemapFactory().createEARProjectMap();
        res.getContents().add((Object)root);
        res.setModified(false);
        return res;
    }

    public Resource makeRoot(Resource deploymentDescriptor) {
        Application app = ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory().createApplication();
        app.setDisplayName(this.getProject().getName());
        ((XMIResource)app.eResource()).setID((EObject)app, "Application_ID");
        deploymentDescriptor.getContents().add((Object)app);
        return deploymentDescriptor;
    }

    protected void notifyListeners(EditModelEvent anEvent) {
        if (!this.stopListenerNotifications) {
            super.notifyListeners(anEvent);
        }
    }

    public void resumeNotifications() {
        this.stopListenerNotifications = false;
    }

    public void stopNotifications() {
        this.stopListenerNotifications = true;
    }

    public void primSave(IProgressMonitor monitor) {
        this.removeInvalidModuleMaps(true);
        super.primSave(monitor);
        try {
            this.updateProjectReferences(monitor);
        }
        catch (CoreException ex) {
            throw new SaveFailedException(EARCreationResourceHandler.getString("PROJ_DESC_UPDATE_ERROR_UI_"), (Exception)((Object)ex));
        }
    }

    /*
     * Exception decompiling
     */
    public void removeInvalidModuleMaps(boolean preserveModifiedFlag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 131->135)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List getExistingModuleMappings() {
        EARProjectMap map = this.getEARProjectMap(false);
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return map.getMappings();
    }

    protected void updateProjectReferences(IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        HashSet newProjects = new HashSet();
        newProjects.addAll(this.getModuleMappedProjects());
        if (!this.hasProjectReferenceChanges(description, newProjects)) {
            return;
        }
        IProject[] newArray = newProjects.toArray(new IProject[newProjects.size()]);
        description.setReferencedProjects(newArray);
        int flags = 3;
        this.getProject().setDescription(description, flags, monitor);
    }

    public boolean hasProjectReferenceChanges() {
        IProjectDescription description;
        try {
            description = this.getProject().getDescription();
        }
        catch (CoreException coreException) {
            return false;
        }
        HashSet newProjects = new HashSet();
        newProjects.addAll(this.getModuleMappedProjects());
        return this.hasProjectReferenceChanges(description, newProjects);
    }

    protected boolean hasProjectReferenceChanges(IProjectDescription description, Set newProjects) {
        IProject[] projects = description.getReferencedProjects();
        HashSet<IProject> oldProjects = new HashSet<IProject>();
        oldProjects.addAll(Arrays.asList(projects));
        return !oldProjects.equals(newProjects);
    }

    public List getNonResourceFiles() {
        IFile aFile = this.getProject().getFile(".project");
        return Collections.singletonList(aFile);
    }

    public XMLResource getDeploymentDescriptorResource() {
        return this.getApplicationXmiResource();
    }

    public boolean hasMappingToProject(IProject p) {
        return this.getModuleMapping(p) != null || this.getUtilityJARMapping(p) != null;
    }

    public IProject getProjectFromUtilJarMapping(UtilityJARMapping utilJarMapping) {
        if (utilJarMapping != null) {
            String projectName = utilJarMapping.getProjectName();
            return this.getProject(projectName);
        }
        return null;
    }

    public boolean isEjbClientJarMapping(UtilityJARMapping utilJarMapping) {
        IProject aProject = this.getProjectFromUtilJarMapping(utilJarMapping);
        if (aProject != null) {
            return this.isEjbClientJarProject(aProject);
        }
        return false;
    }

    public boolean isEjbClientJarProject(IProject utilProject) {
        if (utilProject != null) {
            List mappings = this.getModuleMappings();
            int i = 0;
            while (i < mappings.size()) {
                ModuleMapping mapping = (ModuleMapping)mappings.get(i);
                if (mapping.getModule() != null && mapping.getModule().isEjbModule()) {
                    IProject ejbProject = this.getProject(mapping);
                    if (utilProject.equals((Object)EarModuleManager.getEJBModuleExtension().getDefinedEJBClientJARProject(ejbProject))) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public Object getRootObject() {
        return this.getApplication();
    }

    public String getDevelopmentAcivityID() {
        return "com.ibm.wtp.ejb.development";
    }
}

