/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.debug;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.debug.ToggleBreakpointAction;

public class ToggleBreakpointsTarget
implements IToggleBreakpointsTarget {
    static final IToggleBreakpointsTarget instance = new ToggleBreakpointsTarget();
    static /* synthetic */ Class class$0;

    public static IToggleBreakpointsTarget getInstance() {
        return instance;
    }

    private ToggleBreakpointsTarget() {
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITextEditor editor = (ITextEditor)part.getAdapter((Class)clazz);
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            int lineNumber = -1;
            try {
                lineNumber = document.getLineOfOffset(textSelection.getOffset());
            }
            catch (BadLocationException badLocationException) {}
            if (lineNumber >= 0) {
                ToggleBreakpointAction toggler = new ToggleBreakpointAction(editor, null);
                toggler.update();
                return toggler.isEnabled();
            }
        }
        return false;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    private IBreakpoint[] getBreakpoints(IResource resource, IDocument document, AbstractMarkerAnnotationModel model, int lineNumber) {
        ArrayList<IMarker> markers;
        block9: {
            markers = new ArrayList<IMarker>();
            if (resource != null && model != null && resource.exists()) {
                try {
                    IMarker[] allMarkers = resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                    if (allMarkers == null) break block9;
                    int i = 0;
                    while (i < allMarkers.length) {
                        Position p = model.getMarkerPosition(allMarkers[i]);
                        int markerLine = -1;
                        try {
                            markerLine = document.getLineOfOffset(p.getOffset());
                        }
                        catch (BadLocationException badLocationException) {}
                        if (markerLine == lineNumber) {
                            markers.add(allMarkers[i]);
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>(markers.size());
        int i = 0;
        while (i < markers.size()) {
            IBreakpoint breakpoint = manager.getBreakpoint((IMarker)markers.get(i));
            if (breakpoint != null) {
                breakpoints.add(breakpoint);
            }
            ++i;
        }
        return breakpoints.toArray(new IBreakpoint[0]);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITextEditor editor = (ITextEditor)part.getAdapter((Class)clazz);
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            int lineNumber = -1;
            try {
                lineNumber = document.getLineOfOffset(textSelection.getOffset());
            }
            catch (BadLocationException badLocationException) {}
            if (lineNumber >= 0) {
                ToggleBreakpointAction toggler = new ToggleBreakpointAction(editor, null);
                toggler.update();
                if (toggler.isEnabled()) {
                    AbstractMarkerAnnotationModel model;
                    IResource resource = toggler.getResource();
                    IBreakpoint[] breakpoints = this.getBreakpoints(resource, document, model = toggler.getAnnotationModel(), lineNumber);
                    if (breakpoints.length > 0) {
                        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                        int i = 0;
                        while (i < breakpoints.length) {
                            breakpoints[i].getMarker().delete();
                            breakpointManager.removeBreakpoint(breakpoints[i], true);
                            ++i;
                        }
                    } else {
                        toggler.createBreakpoints(lineNumber + 1);
                    }
                }
            }
        }
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }
}

