/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.extension.RegistryReader;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.IBreakpointProvider;
import org.osgi.framework.Bundle;

public class BreakpointProviderBuilder
extends RegistryReader {
    private static final String ATT_CLASS = "class";
    private static final String ATT_CONTENT_TYPES = "contentTypes";
    private static final String ATT_EXTENSIONS = "extensions";
    private static BreakpointProviderBuilder instance;
    private static final String PL_BREAKPOINT = "breakpoint";
    private static final String PLUGIN_ID = "org.eclipse.wst.sse.ui";
    private static final String TAG_BREAKPOINT_CONTRIBUTION = "breakpointContribution";
    private static final String TAG_PROVIDER = "provider";
    protected List cache;
    private Map map = new HashMap();
    protected String targetContributionTag;
    static /* synthetic */ Class class$0;

    static Object createExecutableExtension(IConfigurationElement element, String classAttribute) throws CoreException {
        return element.createExecutableExtension(classAttribute);
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) {
        final Object[] result = new Object[1];
        String pluginId = element.getDeclaringExtension().getNamespace();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle.getState() == 32) {
            try {
                result[0] = BreakpointProviderBuilder.createExecutableExtension(element, classAttribute);
            }
            catch (Exception e) {
                BreakpointProviderBuilder.handleCreateExecutableException(result, e);
            }
        } else {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    try {
                        result[0] = BreakpointProviderBuilder.createExecutableExtension(element, classAttribute);
                    }
                    catch (CoreException e) {
                        BreakpointProviderBuilder.handleCreateExecutableException(result, e);
                    }
                }
            });
        }
        return result[0];
    }

    public static synchronized BreakpointProviderBuilder getInstance() {
        if (instance == null) {
            instance = new BreakpointProviderBuilder();
        }
        return instance;
    }

    private static void handleCreateExecutableException(Object[] result, Throwable e) {
        Logger.logException(e);
        result[0] = null;
    }

    private BreakpointProviderBuilder() {
    }

    protected IBreakpointProvider createBreakpointProvider(IConfigurationElement element) {
        Object obj = BreakpointProviderBuilder.createExtension(element, ATT_CLASS);
        if (obj == null) {
            return null;
        }
        return obj instanceof IBreakpointProvider ? (IBreakpointProvider)obj : null;
    }

    protected IBreakpointProvider[] createBreakpointProviders(String attrName, String key) {
        if (this.cache == null) {
            return new IBreakpointProvider[0];
        }
        int num = this.cache.size();
        if (num == 0) {
            return new IBreakpointProvider[0];
        }
        IBreakpointProvider[] bp = new IBreakpointProvider[num];
        int j = 0;
        int i = 0;
        while (i < num) {
            IConfigurationElement element;
            Object obj = this.cache.get(i);
            if (obj instanceof IConfigurationElement && TAG_PROVIDER.equals((element = (IConfigurationElement)obj).getName())) {
                IBreakpointProvider b;
                boolean doCreate = false;
                String attrValues = element.getAttribute(attrName);
                if (attrValues != null) {
                    StringTokenizer tokenizer = new StringTokenizer(attrValues, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String type = tokenizer.nextToken();
                        if (!type.trim().equalsIgnoreCase(key.trim())) continue;
                        doCreate = true;
                        break;
                    }
                }
                if (doCreate && (b = this.createBreakpointProvider(element)) != null) {
                    bp[j] = b;
                    ++j;
                }
            }
            ++i;
        }
        IBreakpointProvider[] bp2 = new IBreakpointProvider[j];
        int i2 = 0;
        while (i2 < j) {
            bp2[i2] = bp[i2];
            ++i2;
        }
        return bp2;
    }

    protected IConfigurationElement[] findElements(String key) {
        this.initCache();
        if (this.cache == null || this.cache.size() == 0) {
            return new IConfigurationElement[0];
        }
        int num = this.cache.size();
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>(1);
        int i = 0;
        while (i < num) {
            IConfigurationElement element;
            Object obj = this.cache.get(i);
            if (obj instanceof IConfigurationElement && TAG_PROVIDER.equals((element = (IConfigurationElement)obj).getName())) {
                boolean add = false;
                String types = element.getAttribute(ATT_CONTENT_TYPES);
                String exts = element.getAttribute(ATT_EXTENSIONS);
                if (types == null && exts == null) {
                    add = true;
                }
                if (!add && types != null && types.length() > 0) {
                    IContentType testType = Platform.getContentTypeManager().getContentType(key);
                    StringTokenizer tokenizer = new StringTokenizer(types, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String type = tokenizer.nextToken();
                        IContentType contentType = Platform.getContentTypeManager().getContentType(type);
                        if (contentType == null || testType == null || !contentType.isKindOf(testType)) continue;
                        add = true;
                        break;
                    }
                }
                if (!add && exts != null) {
                    StringTokenizer tokenizer = new StringTokenizer(exts, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String ext = tokenizer.nextToken();
                        if (!ext.trim().equals(key.trim())) continue;
                        add = true;
                        break;
                    }
                }
                if (add) {
                    elements.add(element);
                }
            }
            ++i;
        }
        return elements.toArray(new IConfigurationElement[0]);
    }

    public IBreakpointProvider[] getBreakpointProviders(IEditorPart editorpart, String contentTypeID, String ext) {
        this.initCache();
        IBreakpointProvider[] providers1 = new IBreakpointProvider[]{};
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeID);
        ArrayList<IBreakpointProvider> holdProviders = new ArrayList<IBreakpointProvider>(2);
        while (contentType != null) {
            IBreakpointProvider[] providers = (IBreakpointProvider[])this.map.get(contentType.getId());
            if (providers == null && (providers = this.createBreakpointProviders(ATT_CONTENT_TYPES, contentType.getId())) != null) {
                this.map.put(contentType.getId(), providers);
            }
            if (providers != null) {
                holdProviders.addAll(Arrays.asList(providers));
            }
            contentType = contentType.getBaseType();
        }
        providers1 = holdProviders.toArray(new IBreakpointProvider[holdProviders.size()]);
        IBreakpointProvider[] providers2 = new IBreakpointProvider[]{};
        if (ext != null && (providers2 = (IBreakpointProvider[])this.map.get(ext)) == null && (providers2 = this.createBreakpointProviders(ATT_EXTENSIONS, ext)) != null) {
            this.map.put(ext, providers2);
        }
        HashSet<IBreakpointProvider> s = new HashSet<IBreakpointProvider>();
        s.addAll(Arrays.asList(providers1));
        s.addAll(Arrays.asList(providers2));
        IBreakpointProvider[] providers = new IBreakpointProvider[s.size()];
        Iterator itr = s.iterator();
        int i = 0;
        ISourceEditingTextTools tools = null;
        if (editorpart != null && itr.hasNext()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            tools = (ISourceEditingTextTools)editorpart.getAdapter((Class)clazz);
        }
        while (itr.hasNext()) {
            providers[i] = (IBreakpointProvider)itr.next();
            providers[i].setSourceEditingTextTools(tools);
            ++i;
        }
        return providers;
    }

    public IResource getResource(IEditorInput input, String contentType, String ext) {
        IBreakpointProvider[] providers = this.getBreakpointProviders(null, contentType, ext);
        IResource res = null;
        int i = 0;
        while (i < providers.length) {
            res = providers[i].getResource(input);
            if (res != null) break;
            ++i;
        }
        return res;
    }

    private void initCache() {
        if (this.cache == null) {
            this.cache = new ArrayList();
            this.readContributions(TAG_BREAKPOINT_CONTRIBUTION, PL_BREAKPOINT);
        }
    }

    public boolean isAvailable(String contentType, String ext) {
        boolean available;
        boolean bl = available = this.findElements(ext).length > 0;
        if (!available && contentType != null) {
            available = this.findElements(contentType).length > 0;
        }
        return available;
    }

    protected void readContributions(String tag, String extensionPoint) {
        this.targetContributionTag = tag;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        this.readRegistry(registry, PLUGIN_ID, extensionPoint);
    }

    protected boolean readElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(this.targetContributionTag)) {
            this.readElementChildren(element);
            return true;
        }
        if (tag.equals(TAG_PROVIDER)) {
            this.cache.add(element);
            return true;
        }
        return false;
    }
}

