/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.fwk.validator;

import java.util.logging.Level;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.plugin.JavaEMFNature;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.BVTValidationRegistryReader;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;

public final class JDTUtility {
    private JDTUtility() {
    }

    public static IContainer[] getJavaContainers(IJavaProject jp) {
        if (jp == null) {
            return null;
        }
        IProject project = jp.getProject();
        IClasspathEntry[] classpath = null;
        try {
            classpath = jp.getResolvedClasspath(true);
        }
        catch (JavaModelException exc) {
            exc.printStackTrace();
            return null;
        }
        if (classpath == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] icontainers = new IContainer[classpath.length];
        int validCount = 0;
        int i = 0;
        while (i < classpath.length) {
            IResource res;
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 3 && (res = root.findMember(entry.getPath())) != null && res.getProject().equals((Object)project) && res instanceof IContainer) {
                icontainers[validCount++] = (IContainer)res;
            }
            ++i;
        }
        try {
            IContainer outputContainer = (IContainer)root.findMember(jp.getOutputLocation());
            IContainer[] containers = null;
            if (outputContainer == null) {
                containers = new IContainer[validCount];
            } else if (outputContainer.getProject().equals((Object)project)) {
                containers = new IContainer[validCount + 1];
                containers[validCount] = outputContainer;
            } else {
                containers = new IContainer[validCount];
            }
            System.arraycopy(icontainers, 0, containers, 0, validCount);
            return containers;
        }
        catch (JavaModelException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static IType getType(IContainer[] javaContainers, IFile file) {
        if (file == null) {
            return null;
        }
        String fileExtension = file.getFileExtension();
        if (fileExtension == null) {
            return null;
        }
        if (!fileExtension.equals("java") && !fileExtension.equals("class")) {
            return null;
        }
        IProject project = file.getProject();
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null) {
            return null;
        }
        try {
            IPath relativePath = JDTUtility.getRelativePath(javaContainers, (IResource)file);
            if (relativePath == null) {
                return null;
            }
            IPath packagePath = relativePath.removeLastSegments(1);
            String packageName = packagePath.toString().replace('/', '.');
            String typeName = relativePath.lastSegment();
            typeName = typeName.substring(0, typeName.length() - fileExtension.length() - 1);
            String qualifiedName = null;
            qualifiedName = packageName.length() > 0 ? String.valueOf(packageName) + "." + typeName : typeName;
            return jp.findType(qualifiedName);
        }
        catch (JavaModelException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static IPath getRelativePath(IContainer[] containers, IResource resource) {
        int i = 0;
        while (i < containers.length) {
            IPath path = JDTUtility.getRelativePath(containers[i], resource);
            if (path != null) {
                return path;
            }
            ++i;
        }
        return null;
    }

    public static IPath getRelativePath(IContainer container, IResource resource) {
        if (resource == null || container == null) {
            return null;
        }
        int matchingFirstSegments = container.getFullPath().matchingFirstSegments(resource.getFullPath());
        if (matchingFirstSegments == 0) {
            return null;
        }
        return resource.getFullPath().removeFirstSegments(matchingFirstSegments);
    }

    public static JavaHelpers getJavaHelpers(IFile file) {
        IType type = JDTUtility.getType(file);
        if (type == null) {
            return null;
        }
        return JDTUtility.getJavaHelpers(type);
    }

    public static IType getType(IFile file) {
        IContainer[] javaContainers;
        IJavaProject jp = JavaCore.create((IProject)file.getProject());
        IContainer[] iContainerArray = javaContainers = jp == null ? null : JDTUtility.getJavaContainers(jp);
        if (javaContainers != null) {
            return JDTUtility.getType(javaContainers, file);
        }
        return null;
    }

    public static JavaHelpers getJavaHelpers(IType type) {
        ResourceSet resourceSet = JDTUtility.getResourceSet(type);
        if (resourceSet == null) {
            return null;
        }
        return JavaRefFactory.eINSTANCE.reflectType(type.getFullyQualifiedName(), resourceSet);
    }

    public static ResourceSet getResourceSet(IType type) {
        JavaEMFNature nature = JDTUtility.getNature(type);
        if (nature == null) {
            return null;
        }
        return nature.getResourceSet();
    }

    public static JavaEMFNature getNature(IType type) {
        IJavaProject jp = type.getJavaProject();
        IProject project = jp.getProject();
        try {
            JavaEMFNature nature = JavaEMFNature.createRuntime((IProject)project);
            return nature;
        }
        catch (CoreException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static IResource getResource(IProject project, JavaHelpers clazz) {
        IType type = JDTUtility.getType(project, clazz);
        return type.getResource();
    }

    public static IType getType(IProject project, JavaHelpers clazz) {
        if (clazz == null) {
            return null;
        }
        String fullyQualifiedName = clazz.getJavaName();
        IJavaProject jp = JavaCore.create((IProject)project);
        try {
            return jp.findType(fullyQualifiedName);
        }
        catch (JavaModelException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static ValidatorTestcase[] getVFTests(IProgressMonitor monitor, IProject project) {
        ValidatorTestcase[] tmds = BVTValidationRegistryReader.getReader().getAllValidatorTests(monitor, project);
        if (tmds == null || tmds.length == 0) {
            return new ValidatorTestcase[0];
        }
        ValidatorTestcase fwkNobuildTestTMD = null;
        ValidatorTestcase fwkTestTMD = null;
        ValidatorTestcase propTMD = null;
        ValidatorTestcase[] result = new ValidatorTestcase[3];
        int count = 0;
        int i = 0;
        while (i < tmds.length) {
            ValidatorTestcase tmd = tmds[i];
            if (tmd.getValidatorClass().equals("org.eclipse.jst.validation.test.fwk.validator.FwkTestValidator")) {
                fwkTestTMD = tmd;
                result[count++] = tmd;
            } else if (tmd.getValidatorClass().equals("org.eclipse.wst.validation.sample.PropertiesValidator")) {
                propTMD = tmd;
                result[count++] = tmd;
            } else if (tmd.getValidatorClass().equals("org.eclipse.jst.validation.test.fwk.validator.FwkNoBuildTestValidator")) {
                fwkNobuildTestTMD = tmd;
                result[count++] = tmd;
            }
            if (fwkTestTMD != null && propTMD != null && fwkNobuildTestTMD != null) break;
            ++i;
        }
        if (count != result.length) {
            ValidatorTestcase[] r = new ValidatorTestcase[count];
            System.arraycopy(result, 0, r, 0, count);
            return r;
        }
        return result;
    }

    public static void setAutoBuild(boolean autoBuildEnabled) {
        block2: {
            try {
                IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
                desc.setAutoBuilding(autoBuildEnabled);
                ResourcesPlugin.getWorkspace().setDescription(desc);
            }
            catch (CoreException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                logger.write(Level.SEVERE, (Exception)((Object)exc));
            }
        }
    }
}

