/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.registry;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.sample.parser.PropertyLine;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.MessageMetaData;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public class MessageUtility {
    private static final String _TESTCASE_MESSAGE_TEMPLATE_ = "<message prefix=\"{0}\" resource=\"{1}\" location=\"{2}\" text=\"{3}\"/>";
    private static final String _TESTCASE_MARKER_TEMPLATE_ = "<marker prefix=\"{0}\" resource=\"{1}\" location=\"{2}\" text=\"{3}\"/>";
    private static MessageComparator _messageComparator = null;
    private static MessageIdComparator _messageIdComparator = null;
    private static MessagePrefixComparator _messagePrefixComparator = null;

    private MessageUtility() {
    }

    public static String toString(MessageMetaData mmd) {
        String location = mmd.isSetLineNumber() ? String.valueOf(mmd.getLineNumber()) : mmd.getLocation();
        return MessageUtility.toString(mmd.getMessagePrefix(), mmd.getResource(), location, mmd.getText(), _TESTCASE_MESSAGE_TEMPLATE_);
    }

    public static String toString(IMarker marker) {
        String location;
        Integer lineNumber = MessageUtility.getLineNumber(marker);
        location = lineNumber == null ? (location = MessageUtility.getLocation(marker)) : (location = lineNumber.toString());
        return MessageUtility.toString(MessageUtility.getMessagePrefix(marker), MessageUtility.getResource(marker), location, MessageUtility.getMessage(marker), _TESTCASE_MARKER_TEMPLATE_);
    }

    private static String toString(String fmssgPrefix, String fresource, String flocation, String ftext, String template) {
        String mssgPrefix = fmssgPrefix == null ? "" : fmssgPrefix;
        String resource = fresource == null ? "" : fresource;
        String location = flocation == null ? "" : flocation;
        String text = ftext == null ? "" : ftext;
        return MessageFormat.format(template, mssgPrefix, resource, location, text);
    }

    public static String getProject(IMarker marker) {
        return marker.getResource().getProject().getName();
    }

    public static String getResource(IMarker marker) {
        return marker.getResource().getProjectRelativePath().toString();
    }

    public static Integer getSeverity(IMarker marker) throws CoreException {
        String message = (String)marker.getAttribute("message");
        if (message == null) {
            return null;
        }
        String[] tokens = MessageUtility.parse(message);
        String severity = tokens[1];
        Integer result = severity.equals("E") ? new Integer(2) : (severity.equals("W") ? new Integer(1) : (severity.equals("I") ? new Integer(0) : null));
        return result;
    }

    public static String getMessage(IMarker marker) {
        try {
            return (String)marker.getAttribute("message");
        }
        catch (CoreException e) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)((Object)e));
            }
            return null;
        }
    }

    public static String getMessagePrefix(IMarker marker) {
        String message = MessageUtility.getMessage(marker);
        if (message == null) {
            return null;
        }
        String[] tokens = MessageUtility.parse(message);
        return tokens[0];
    }

    public static String getResource(MessageMetaData mmd) {
        String resource = mmd.getResource();
        int index = resource.indexOf(".java");
        if (index > -1) {
            return resource.substring(0, index);
        }
        index = resource.indexOf(".class");
        if (index > -1) {
            return resource.substring(0, index);
        }
        return resource;
    }

    public static ValidatorMetaData getValidator(IMarker marker) {
        String validatorClass = ConfigurationManager.getManager().getValidator(marker);
        ValidatorMetaData vmd = ValidationRegistryReader.getReader().getValidatorMetaData(validatorClass);
        return vmd;
    }

    public static String[] parse(String message) {
        String tempString;
        char[] temp;
        if (message == null) {
            return new String[]{"", "", ""};
        }
        StringTokenizer tokenizer = new StringTokenizer(message);
        int numTokens = tokenizer.countTokens();
        if (numTokens == 0) {
            return new String[]{"", "", message};
        }
        String errorId = tokenizer.nextToken();
        boolean isErrorIndex = false;
        int errorIdIndex = errorId.indexOf(58);
        if (errorIdIndex > 0 && (temp = (tempString = errorId.substring(0, errorIdIndex)).toCharArray()).length == 9) {
            isErrorIndex = Character.isLetter(temp[0]);
            isErrorIndex = isErrorIndex && Character.isLetter(temp[1]);
            isErrorIndex = isErrorIndex && Character.isLetter(temp[2]);
            isErrorIndex = isErrorIndex && Character.isLetter(temp[3]);
            isErrorIndex = isErrorIndex && Character.isDigit(temp[4]);
            isErrorIndex = isErrorIndex && Character.isDigit(temp[5]);
            isErrorIndex = isErrorIndex && Character.isDigit(temp[6]);
            isErrorIndex = isErrorIndex && Character.isDigit(temp[7]);
            boolean bl = isErrorIndex = isErrorIndex && Character.isLetter(temp[8]);
            if (isErrorIndex) {
                String shortMessage = numTokens > 1 ? message.substring(errorIdIndex + 1, message.length()).intern() : "";
                return new String[]{tempString.substring(0, 8), new String(new char[]{temp[8]}), shortMessage};
            }
        }
        if (!isErrorIndex) {
            return new String[]{"", "", message};
        }
        return new String[]{"", "", message};
    }

    public static Integer getLineNumber(IMarker marker) {
        try {
            return (Integer)marker.getAttribute("lineNumber");
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String getTargetObject(IMarker marker) {
        try {
            String targetObject = (String)marker.getAttribute("targetObject");
            if (targetObject != null && targetObject.equals("")) {
                return null;
            }
            return targetObject;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static Comparator getMessageComparator(IBuffer buffer, boolean verbose) {
        if (_messageComparator == null) {
            _messageComparator = new MessageUtility().new MessageComparator();
        }
        _messageComparator.setVerbose(verbose);
        _messageComparator.setBuffer(buffer);
        return _messageComparator;
    }

    public static Comparator getMessageIdComparator(IBuffer buffer, boolean verbose) {
        if (_messageIdComparator == null) {
            _messageIdComparator = new MessageUtility().new MessageIdComparator();
        }
        _messageIdComparator.setVerbose(verbose);
        _messageIdComparator.setBuffer(buffer);
        return _messageIdComparator;
    }

    public static String getLocation(IMarker marker) {
        try {
            return (String)marker.getAttribute("location");
        }
        catch (CoreException e) {
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, (Exception)((Object)e));
            }
            return null;
        }
    }

    public static MessagePrefixComparator getMessagePrefixComparator() {
        if (_messagePrefixComparator == null) {
            _messagePrefixComparator = new MessagePrefixComparator();
        }
        return _messagePrefixComparator;
    }

    private class MessageComparator
    implements Comparator {
        private boolean _verbose = false;
        private IBuffer _buffer = null;

        MessageComparator() {
        }

        public boolean isVerbose() {
            return this._verbose;
        }

        public void setVerbose(boolean v) {
            this._verbose = v;
        }

        public IBuffer getBuffer() {
            return this._buffer;
        }

        public void setBuffer(IBuffer b) {
            this._buffer = b;
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            if (a instanceof String && b instanceof String) {
                return this.compare((String)a, (String)b);
            }
            if (a instanceof IMarker && b instanceof IMarker) {
                IMarker aM = (IMarker)a;
                IMarker bM = (IMarker)b;
                int result = this.compare(aM, bM);
                if (this.isVerbose()) {
                    this.getBuffer().write("compare(" + MessageUtility.toString(aM) + ", " + MessageUtility.toString(bM) + " = " + result);
                }
                return result;
            }
            if (a instanceof IMarker && b instanceof MessageMetaData) {
                IMarker aM = (IMarker)a;
                MessageMetaData mmd = (MessageMetaData)b;
                int result = this.compare(aM, mmd);
                if (this.isVerbose()) {
                    this.getBuffer().write("compare(" + MessageUtility.toString(aM) + ", " + MessageUtility.toString(mmd) + " = " + result);
                }
                return result;
            }
            if (a instanceof MessageMetaData && b instanceof IMarker) {
                MessageMetaData mmd = (MessageMetaData)a;
                IMarker bM = (IMarker)b;
                int result = this.compare(mmd, bM);
                if (this.isVerbose()) {
                    this.getBuffer().write("compare(" + MessageUtility.toString(mmd) + ", " + MessageUtility.toString(bM) + " = " + result);
                }
                return result;
            }
            if (a instanceof MessageMetaData && b instanceof MessageMetaData) {
                MessageMetaData aMMD = (MessageMetaData)a;
                MessageMetaData bMMD = (MessageMetaData)b;
                int result = this.compare(aMMD, bMMD);
                if (this.isVerbose()) {
                    this.getBuffer().write("compare(" + MessageUtility.toString(aMMD) + ", " + MessageUtility.toString(bMMD) + " = " + result);
                }
                return result;
            }
            return 1;
        }

        public int compare(String aStr, String bStr) {
            if (aStr == null && bStr == null) {
                return 0;
            }
            if (aStr == null) {
                return 1;
            }
            if (bStr == null) {
                return -1;
            }
            return aStr.compareTo(bStr);
        }

        public int compare(int aInt, int bInt) {
            return aInt - bInt;
        }

        public int compare(ValidatorMetaData aVMD, ValidatorMetaData bVMD) {
            if (aVMD == null && bVMD == null) {
                return 0;
            }
            if (aVMD == null) {
                return 1;
            }
            if (bVMD == null) {
                return -1;
            }
            return this.compare(aVMD.getValidatorUniqueName(), bVMD.getValidatorUniqueName());
        }

        public int compare(IMarker aMarker, IMarker bMarker) {
            if (aMarker == null && bMarker == null) {
                return 0;
            }
            if (aMarker == null) {
                return 1;
            }
            if (bMarker == null) {
                return -1;
            }
            int valCmp = this.compare(MessageUtility.getValidator(aMarker), MessageUtility.getValidator(bMarker));
            if (valCmp != 0) {
                return valCmp;
            }
            int prjCmp = this.compare(MessageUtility.getProject(aMarker), MessageUtility.getProject(bMarker));
            if (prjCmp != 0) {
                return prjCmp;
            }
            int idCmp = this.compare(MessageUtility.getMessagePrefix(aMarker), MessageUtility.getMessagePrefix(bMarker));
            if (idCmp != 0) {
                return idCmp;
            }
            int cmp = this.compareResourceAndLocation(aMarker, bMarker);
            return cmp;
        }

        public int compare(IMarker marker, MessageMetaData mmd) {
            if (marker == null && mmd == null) {
                return 0;
            }
            if (marker == null) {
                return 1;
            }
            if (mmd == null) {
                return -1;
            }
            int valCmp = this.compare(MessageUtility.getValidator(marker), mmd.getValidator());
            if (valCmp != 0) {
                return valCmp;
            }
            int prjCmp = this.compare(MessageUtility.getProject(marker), mmd.getValidatorTestcase().getProjectName());
            if (prjCmp != 0) {
                return prjCmp;
            }
            int idCmp = this.compare(MessageUtility.getMessagePrefix(marker), mmd.getMessagePrefix());
            if (idCmp != 0) {
                return idCmp;
            }
            int cmp = this.compareResourceAndLocation(marker, mmd);
            return cmp;
        }

        public int compare(MessageMetaData mmd, IMarker marker) {
            if (mmd == null && marker == null) {
                return 0;
            }
            if (mmd == null) {
                return 1;
            }
            if (marker == null) {
                return -1;
            }
            int valCmp = this.compare(mmd.getValidator(), MessageUtility.getValidator(marker));
            if (valCmp != 0) {
                return valCmp;
            }
            int prjCmp = this.compare(mmd.getValidatorTestcase().getProjectName(), MessageUtility.getProject(marker));
            if (prjCmp != 0) {
                return prjCmp;
            }
            int idCmp = this.compare(mmd.getMessagePrefix(), MessageUtility.getMessagePrefix(marker));
            if (idCmp != 0) {
                return idCmp;
            }
            int cmp = this.compareResourceAndLocation(mmd, marker);
            return cmp;
        }

        public int compare(MessageMetaData aMMD, MessageMetaData bMMD) {
            if (aMMD == null && bMMD == null) {
                return 0;
            }
            if (aMMD == null) {
                return 1;
            }
            if (bMMD == null) {
                return -1;
            }
            int valCmp = this.compare(aMMD.getValidator(), bMMD.getValidator());
            if (valCmp != 0) {
                return valCmp;
            }
            int prjCmp = this.compare(aMMD.getValidatorTestcase().getProjectName(), bMMD.getValidatorTestcase().getProjectName());
            if (prjCmp != 0) {
                return prjCmp;
            }
            int idCmp = this.compare(aMMD.getMessagePrefix(), bMMD.getMessagePrefix());
            if (idCmp != 0) {
                return idCmp;
            }
            int cmp = this.compareResourceAndLocation(aMMD, bMMD);
            return cmp;
        }

        public int compareResourceAndLocation(IMarker aMarker, IMarker bMarker) {
            int resCmp = this.compare(MessageUtility.getResource(aMarker), MessageUtility.getResource(bMarker));
            if (resCmp != 0) {
                return resCmp;
            }
            Integer aLineNo = MessageUtility.getLineNumber(aMarker);
            Integer bLineNo = MessageUtility.getLineNumber(bMarker);
            if (aLineNo != null && bLineNo != null) {
                return this.compare(aLineNo, bLineNo);
            }
            String aLocation = MessageUtility.getLocation(aMarker);
            String bLocation = MessageUtility.getLocation(bMarker);
            if (aLocation != null && bLocation != null) {
                return this.compare(aLocation, bLocation);
            }
            return resCmp;
        }

        public int compareResourceAndLocation(IMarker marker, MessageMetaData mmd) {
            int resCmp = this.compare(MessageUtility.getResource(marker), mmd.getResource());
            if (resCmp != 0) {
                return resCmp;
            }
            if (mmd.isSetLineNumber()) {
                Integer aLineNo = MessageUtility.getLineNumber(marker);
                int bLineNo = mmd.getLineNumber();
                if (aLineNo != null) {
                    return this.compare(aLineNo, bLineNo);
                }
            }
            if (mmd.isSetLocation()) {
                String aLocation = MessageUtility.getLocation(marker);
                String bLocation = mmd.getLocation();
                if (aLocation != null && bLocation != null) {
                    return this.compare(aLocation, bLocation);
                }
            }
            return resCmp;
        }

        public int compareResourceAndLocation(MessageMetaData mmd, IMarker marker) {
            int resCmp = this.compare(mmd.getResource(), MessageUtility.getResource(marker));
            if (resCmp != 0) {
                return resCmp;
            }
            if (mmd.isSetLineNumber()) {
                int aLineNo = mmd.getLineNumber();
                Integer bLineNo = MessageUtility.getLineNumber(marker);
                if (bLineNo != null) {
                    return this.compare(aLineNo, bLineNo);
                }
            }
            if (mmd.isSetLocation()) {
                String aLocation = mmd.getLocation();
                String bLocation = MessageUtility.getLocation(marker);
                if (aLocation != null && bLocation != null) {
                    return this.compare(aLocation, bLocation);
                }
            }
            return resCmp;
        }

        public int compareResourceAndLocation(MessageMetaData aMMD, MessageMetaData bMMD) {
            int resCmp = this.compare(aMMD.getResource(), bMMD.getResource());
            if (resCmp != 0) {
                return resCmp;
            }
            if (aMMD.isSetLineNumber() && bMMD.isSetLineNumber()) {
                int aLineNo = aMMD.getLineNumber();
                int bLineNo = bMMD.getLineNumber();
                return this.compare(aLineNo, bLineNo);
            }
            if (aMMD.isSetLocation() && bMMD.isSetLocation()) {
                String aLocation = aMMD.getLocation();
                String bLocation = bMMD.getLocation();
                if (aLocation != null && bLocation != null) {
                    return this.compare(aLocation, bLocation);
                }
            }
            return resCmp;
        }
    }

    static class MessagePrefixComparator
    implements Comparator {
        MessagePrefixComparator() {
        }

        public int compare(Object a, Object b) {
            String aPrefix = null;
            String bPrefix = null;
            if (a instanceof PropertyLine) {
                aPrefix = ((PropertyLine)a).getMessagePrefix();
            } else if (a instanceof MessageMetaData) {
                aPrefix = ((MessageMetaData)a).getMessagePrefix();
            }
            if (b instanceof PropertyLine) {
                bPrefix = ((PropertyLine)b).getMessagePrefix();
            } else if (b instanceof MessageMetaData) {
                bPrefix = ((MessageMetaData)b).getMessagePrefix();
            }
            if (aPrefix.length() == 9) {
                aPrefix = aPrefix.substring(0, 9);
            }
            if (bPrefix.length() == 9) {
                bPrefix = bPrefix.substring(0, 9);
            }
            return aPrefix.compareTo(bPrefix);
        }
    }

    class MessageIdComparator
    implements Comparator {
        private boolean _verbose = false;
        private IBuffer _buffer = null;

        MessageIdComparator() {
        }

        public boolean isVerbose() {
            return this._verbose;
        }

        public void setVerbose(boolean v) {
            this._verbose = v;
        }

        public IBuffer getBuffer() {
            return this._buffer;
        }

        public void setBuffer(IBuffer b) {
            this._buffer = b;
        }

        public String getMessageId(IMarker marker) {
            try {
                return (String)marker.getAttribute("messageId");
            }
            catch (CoreException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (logger.isLoggingLevel(Level.SEVERE)) {
                    logger.write(Level.SEVERE, (Exception)((Object)exc));
                }
                return "";
            }
        }

        public int compare(String aStr, String bStr) {
            if (aStr == null && bStr == null) {
                return 0;
            }
            if (aStr == null) {
                return 1;
            }
            if (bStr == null) {
                return -1;
            }
            return aStr.compareTo(bStr);
        }

        public int compare(Object a, Object b) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            if (a instanceof String && b instanceof String) {
                String aStr = (String)a;
                String bStr = (String)b;
                return this.compare(aStr, bStr);
            }
            if (a instanceof PropertyLine && b instanceof PropertyLine) {
                PropertyLine aM = (PropertyLine)a;
                PropertyLine bM = (PropertyLine)b;
                return this.compare(aM.getMessageId(), bM.getMessageId());
            }
            if (a instanceof PropertyLine && b instanceof IMarker) {
                PropertyLine aM = (PropertyLine)a;
                IMarker bM = (IMarker)b;
                return this.compare(aM.getMessageId(), this.getMessageId(bM));
            }
            if (a instanceof IMarker && b instanceof PropertyLine) {
                IMarker aM = (IMarker)a;
                PropertyLine bM = (PropertyLine)b;
                return this.compare(this.getMessageId(aM), bM.getMessageId());
            }
            if (a instanceof IMarker && b instanceof IMarker) {
                IMarker aM = (IMarker)a;
                IMarker bM = (IMarker)b;
                return this.compare(this.getMessageId(aM), this.getMessageId(bM));
            }
            return 1;
        }
    }
}

