/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.setup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.sample.parser.PropertyLine;
import org.eclipse.jst.validation.sample.workbenchimpl.PluginPropertyFile;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.internal.registry.MessageUtility;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.jst.validation.test.internal.util.BVTValidationUtility;
import org.eclipse.jst.validation.test.setup.IBuffer;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public final class CheckForUntestedPropertiesOperation
implements IWorkspaceRunnable {
    private ValidatorMetaData _vmd = null;
    private IBuffer _buffer = null;
    private String _resourceBundleName = null;

    public CheckForUntestedPropertiesOperation(IBuffer buffer, ValidatorMetaData vmd, String resourceBundleName) {
        this.setValidatorMetaData(vmd);
        this.setBuffer(buffer);
        this.setResourceBundleName(resourceBundleName);
    }

    public IBuffer getBuffer() {
        return this._buffer;
    }

    void setBuffer(IBuffer b) {
        this._buffer = b;
    }

    public ValidatorMetaData getValidatorMetaData() {
        return this._vmd;
    }

    private String getPluginId(ValidatorMetaData vmd) {
        block5: {
            try {
                if (vmd != null) {
                    ClassLoader cl = vmd.getValidator().getClass().getClassLoader();
                    IPluginRegistry registry = Platform.getPluginRegistry();
                    IPluginDescriptor[] descriptors = registry.getPluginDescriptors();
                    int i = 0;
                    while (i < descriptors.length) {
                        IPluginDescriptor desc = descriptors[i];
                        if (desc.getPluginClassLoader().equals(cl)) {
                            return desc.getUniqueIdentifier();
                        }
                        ++i;
                    }
                }
            }
            catch (InstantiationException exc) {
                Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block5;
                logger.write(Level.SEVERE, (Exception)exc);
            }
        }
        return null;
    }

    void setValidatorMetaData(ValidatorMetaData vmd) {
        this._vmd = vmd;
    }

    public String getResourceBundleName() {
        return this._resourceBundleName;
    }

    void setResourceBundleName(String name) {
        this._resourceBundleName = name;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        List pLines = null;
        ArrayList<PropertyLine> untestedLines = new ArrayList<PropertyLine>();
        ArrayList testedLines = new ArrayList();
        MessageUtility.MessagePrefixComparator comparator = MessageUtility.getMessagePrefixComparator();
        String propFileName = this.getResourceBundleName();
        ValidatorMetaData vmd = this.getValidatorMetaData();
        monitor.subTask("Attempting to load file: " + propFileName);
        String pluginId = this.getPluginId(vmd);
        if (pluginId == null) {
            monitor.subTask("Cannot load plugin id for validator " + vmd.getValidatorDisplayName());
            Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write(Level.SEVERE, "Cannot load plugin id for validator " + vmd.getValidatorDisplayName());
            }
            return;
        }
        PluginPropertyFile pFile = new PluginPropertyFile(pluginId, propFileName);
        monitor.worked(1);
        monitor.subTask("Parsing.");
        pLines = pFile.getPropertyLines();
        Collections.sort(pLines, comparator);
        monitor.worked(1);
        monitor.subTask("Loading test messages.");
        ValidatorTestcase[] tmds = BVTValidationUtility.getValidatorTests(monitor, vmd);
        int k = 0;
        while (k < tmds.length) {
            ValidatorTestcase tmd = tmds[k];
            List mssg = tmd.getMessages(0);
            testedLines.addAll(mssg);
            ++k;
        }
        Collections.sort(testedLines, comparator);
        monitor.subTask("Comparing.");
        Iterator iterator = pLines.iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            PropertyLine line = (PropertyLine)iterator.next();
            int index = Collections.binarySearch(testedLines, line, comparator);
            if (index >= 0) continue;
            untestedLines.add(line);
        }
        monitor.worked(1);
        Collections.sort(untestedLines, comparator);
        Iterator untestediterator = untestedLines.iterator();
        if (untestediterator.hasNext()) {
            this.getBuffer().write("List of messages which are not tested (" + untestedLines.size() + " of " + pLines.size() + ")");
        } else {
            this.getBuffer().write("All messages are tested.");
        }
        while (untestediterator.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            PropertyLine line = (PropertyLine)untestediterator.next();
            this.getBuffer().write(line.toString());
        }
        untestedLines.clear();
        testedLines.clear();
        monitor.worked(1);
    }
}

