/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLModelNotifierImpl
implements XMLModelNotifier {
    private static final String ADDED_THEN_REMOVED = "Discard: Added then removed rule";
    private static final boolean fOptimizeDeferred = true;
    private static final boolean fOptimizeDeferredAccordingToParentAdded = true;
    private static final boolean fOptimizeDeferredAccordingToParentRemoved = true;
    private static final String PARENT_IS_ADDED = "Disarded: Parent has just been added";
    private static final String PARENT_IS_REMOVED_TOO = "Discard: Parent was removed too";
    private static final String PARENT_IS_REPARENTED = "Not Discard: Parent was removed so this implies reparenting";
    private Node changedRoot = null;
    private boolean changing = false;
    private boolean doingNewModel = false;
    private Vector events = null;
    private boolean flushing = false;

    public void attrReplaced(Element element, Attr newAttr, Attr oldAttr) {
        if (element == null) {
            return;
        }
        Attr attr = null;
        String oldValue = null;
        String newValue = null;
        if (oldAttr != null) {
            attr = oldAttr;
            oldValue = oldAttr.getValue();
        }
        if (newAttr != null) {
            attr = newAttr;
            newValue = newAttr.getValue();
        }
        IDOMNode notifier = (IDOMNode)((Object)element);
        int offset = notifier.getStartOffset();
        this.notify(notifier, 1, attr, oldValue, newValue, offset);
        this.propertyChanged(notifier);
    }

    public void beginChanging() {
        this.changing = true;
    }

    public void beginChanging(boolean newModel) {
        this.beginChanging();
        this.doingNewModel = newModel;
    }

    public void cancelPending() {
        if (this.events != null) {
            Iterator iterator = this.events.iterator();
            while (iterator.hasNext()) {
                NotifyEvent event = (NotifyEvent)iterator.next();
                event.discarded = true;
            }
        }
        this.changedRoot = null;
    }

    public void childReplaced(Node parentNode, Node newChild, Node oldChild) {
        if (parentNode == null) {
            return;
        }
        IDOMNode notifier = (IDOMNode)parentNode;
        int type = 1;
        if (newChild == null) {
            type = 3;
        } else if (oldChild == null) {
            type = 2;
        }
        int offset = notifier.getStartOffset();
        this.notify(notifier, type, oldChild, oldChild, newChild, offset);
        this.structureChanged(notifier);
    }

    public void editableChanged(Node node) {
        if (node == null) {
            return;
        }
        IDOMNode notifier = (IDOMNode)node;
        int offset = notifier.getStartOffset();
        this.notify(notifier, 1, null, null, null, offset);
        this.propertyChanged(notifier);
    }

    public void endChanging() {
        this.doingNewModel = false;
        if (!this.changing) {
            return;
        }
        this.notifyDeferred();
        if (this.changedRoot != null) {
            this.notifyStructureChanged(this.changedRoot);
            this.changedRoot = null;
        }
        this.changing = false;
    }

    public void endTagChanged(Element element) {
        if (element == null) {
            return;
        }
        IDOMNode notifier = (IDOMNode)((Object)element);
        int offset = notifier.getStartOffset();
        this.notify(notifier, 1, null, null, null, offset);
        this.propertyChanged(element);
    }

    public boolean hasChanged() {
        return this.events != null;
    }

    public boolean isChanging() {
        return this.changing;
    }

    private void notify(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier == null) {
            return;
        }
        if (this.changing && !this.flushing) {
            if (this.events == null) {
                this.events = new Vector();
            }
            if (!this.doingNewModel || ((Node)notifier).getNodeType() == 9) {
                this.events.addElement(new NotifyEvent(notifier, eventType, changedFeature, oldValue, newValue, pos));
            }
            return;
        }
        try {
            notifier.notify(eventType, changedFeature, oldValue, newValue, pos);
        }
        catch (Exception e) {
            Logger.logException("A structured model client threw following exception during adapter notification (" + INodeNotifier.EVENT_TYPE_STRINGS[eventType] + " )", e);
        }
    }

    private void notifyDeferred() {
        if (this.events == null) {
            return;
        }
        if (this.flushing) {
            return;
        }
        this.flushing = true;
        int count = this.events.size();
        int i = 0;
        while (i < count) {
            block14: {
                NotifyEvent event;
                block15: {
                    NotifyEvent next;
                    int n;
                    block16: {
                        event = (NotifyEvent)this.events.elementAt(i);
                        if (event == null || event.discarded) break block14;
                        if (this.doingNewModel) break block15;
                        if (event.type != 2) break block16;
                        n = i + 1;
                        while (n < count) {
                            next = (NotifyEvent)this.events.elementAt(n);
                            if (next != null && next.type == 3 && next.oldValue == event.newValue) {
                                event.discarded = true;
                                next.discarded = true;
                                break;
                            }
                            ++n;
                        }
                        if (event.discarded) break block14;
                        int p = 0;
                        while (p < i) {
                            NotifyEvent prev = (NotifyEvent)this.events.elementAt(p);
                            if (prev != null) {
                                if (prev.type == 3 && prev.oldValue == event.notifier) break;
                                if (prev.type == 2 && prev.newValue == event.notifier) {
                                    event.discarded = true;
                                    break;
                                }
                            }
                            ++p;
                        }
                        if (!event.discarded) break block15;
                        break block14;
                    }
                    if (event.type != 3) break block15;
                    n = i + 1;
                    while (n < count) {
                        next = (NotifyEvent)this.events.elementAt(n);
                        if (next != null && next.type == 3 && next.oldValue == event.notifier) {
                            event.discarded = true;
                            break;
                        }
                        ++n;
                    }
                    if (event.discarded) break block14;
                }
                this.notify(event.notifier, event.type, event.changedFeature, event.oldValue, event.newValue, event.pos);
            }
            ++i;
        }
        this.flushing = false;
        this.events = null;
    }

    private void notifyStructureChanged(Node root) {
        if (root == null) {
            return;
        }
        INodeNotifier notifier = (INodeNotifier)root;
        try {
            notifier.notify(4, null, null, null, -1);
        }
        catch (Exception e) {
            Logger.logException("A structured model client threw following exception during adapter notification (" + INodeNotifier.EVENT_TYPE_STRINGS[4] + " )", e);
        }
    }

    public void propertyChanged(Node node) {
    }

    private void setCommonRootIfNeeded(Node node) {
        if (this.changedRoot == null) {
            this.changedRoot = node;
        } else if (this.changedRoot.getNodeType() != 9 && this.changedRoot != node) {
            Node common = ((NodeImpl)this.changedRoot).getCommonAncestor(node);
            this.changedRoot = common != null ? common : node;
        }
    }

    public void startTagChanged(Element element) {
        if (element == null) {
            return;
        }
        IDOMNode notifier = (IDOMNode)((Object)element);
        int offset = notifier.getStartOffset();
        this.notify(notifier, 1, null, null, null, offset);
        this.propertyChanged(element);
    }

    public void structureChanged(Node node) {
        if (node == null) {
            return;
        }
        if (this.isChanging()) {
            this.setCommonRootIfNeeded(node);
            return;
        }
        this.notifyStructureChanged(node);
    }

    public void valueChanged(Node node) {
        if (node == null) {
            return;
        }
        IDOMNode notifier = null;
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            notifier = (IDOMNode)((Object)attr.getOwnerElement());
            if (notifier == null) {
                return;
            }
            String value = attr.getValue();
            int offset = notifier.getStartOffset();
            this.notify(notifier, 1, attr, null, value, offset);
        } else {
            IDOMNode parent;
            notifier = (IDOMNode)node;
            String value = node.getNodeValue();
            int offset = notifier.getStartOffset();
            this.notify(notifier, 1, null, null, value, offset);
            if (node.getNodeType() != 1 && (parent = (IDOMNode)node.getParentNode()) != null) {
                this.notify(parent, 5, node, null, value, offset);
            }
        }
        this.propertyChanged(notifier);
    }

    private class NotifyEvent {
        Object changedFeature;
        boolean discarded;
        Object newValue;
        INodeNotifier notifier;
        Object oldValue;
        int pos;
        String reason;
        int type;

        NotifyEvent(INodeNotifier notifier, int type, Object changedFeature, Object oldValue, Object newValue, int pos) {
            this.notifier = notifier;
            this.type = type;
            this.changedFeature = changedFeature;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.pos = pos;
            this.reason = "";
        }
    }
}

