/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.tests.viewer;

import junit.framework.TestCase;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.dtd.ui.internal.DTDUIPlugin;
import org.eclipse.wst.dtd.ui.internal.provisional.StructuredTextViewerConfigurationDTD;
import org.eclipse.wst.dtd.ui.tests.internal.Logger;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.IHighlighter;

public class TestViewerConfigurationDTD
extends TestCase {
    private StructuredTextViewer fViewer = null;
    private StructuredTextViewerConfigurationDTD fConfig = null;
    private IPreferenceStore fPreferenceStore = null;
    private boolean fDisplayExists = true;
    private boolean isSetup = false;

    public TestViewerConfigurationDTD() {
        super("TestViewerConfigurationDTD");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.setUpPreferences();
            this.setUpViewerConfiguration();
            this.isSetup = true;
        }
    }

    private void setUpPreferences() {
        this.fPreferenceStore = DTDUIPlugin.getDefault().getPreferenceStore();
        this.fPreferenceStore.setValue("hyperlinksEnabled", true);
    }

    private void setUpViewerConfiguration() {
        if (Display.getCurrent() != null) {
            Shell shell = null;
            Composite parent = null;
            shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            parent = new Composite((Composite)shell, 0);
            this.fViewer = new StructuredTextViewer(parent, null, null, false, 0);
            this.fConfig = new StructuredTextViewerConfigurationDTD(this.fPreferenceStore);
        } else {
            this.fDisplayExists = false;
            Logger.log(1, "Remember, viewer configuration tests are not run because workbench is not open (normal on build machine)");
        }
    }

    public void testGetAutoEditStrategies() {
        if (!this.fDisplayExists) {
            return;
        }
        IAutoEditStrategy[] strategies = this.fConfig.getAutoEditStrategies((ISourceViewer)this.fViewer, "org.eclipse.wst.dtd.DEFAULT");
        TestViewerConfigurationDTD.assertNotNull((Object)strategies);
        TestViewerConfigurationDTD.assertTrue((String)"there are no auto edit strategies", (strategies.length > 0 ? 1 : 0) != 0);
    }

    public void testGetConfiguredContentTypes() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] configuredContentTypes = this.fConfig.getConfiguredContentTypes((ISourceViewer)this.fViewer);
        TestViewerConfigurationDTD.assertNotNull((Object)configuredContentTypes);
        TestViewerConfigurationDTD.assertTrue((String)"there are no configured content types", (configuredContentTypes.length > 1 ? 1 : 0) != 0);
    }

    public void testGetContentAssistant() {
        if (!this.fDisplayExists) {
            return;
        }
        IContentAssistant ca = this.fConfig.getContentAssistant((ISourceViewer)this.fViewer);
        TestViewerConfigurationDTD.assertNotNull((String)"there is no content assistant", (Object)ca);
    }

    public void testGetCorrectionAssistant() {
        if (!this.fDisplayExists) {
            return;
        }
        IContentAssistant ca = this.fConfig.getCorrectionAssistant((ISourceViewer)this.fViewer);
        TestViewerConfigurationDTD.assertNotNull((String)"there is no correction assistant", (Object)ca);
    }

    public void testGetDoubleClickStrategy() {
        if (!this.fDisplayExists) {
            return;
        }
        String[] contentTypes = this.fConfig.getConfiguredContentTypes((ISourceViewer)this.fViewer);
        int i = 0;
        while (i < contentTypes.length) {
            ITextDoubleClickStrategy strategy = this.fConfig.getDoubleClickStrategy((ISourceViewer)this.fViewer, contentTypes[i]);
            if (strategy != null) {
                return;
            }
            ++i;
        }
        TestViewerConfigurationDTD.assertTrue((String)"there are no configured double click strategies", (boolean)false);
    }

    public void testGetHighlighter() {
        if (!this.fDisplayExists) {
            return;
        }
        IHighlighter highlighter = this.fConfig.getHighlighter((ISourceViewer)this.fViewer);
        TestViewerConfigurationDTD.assertNotNull((String)"Highlighter is null", (Object)highlighter);
    }

    public void testUnconfigure() {
        if (!this.fDisplayExists) {
            return;
        }
        this.fConfig.unConfigure((ISourceViewer)this.fViewer);
        this.setUpViewerConfiguration();
    }
}

