/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.actions;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.j2ee.internal.actions.BaseAction;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistry;
import org.eclipse.jst.j2ee.internal.deploy.J2EEDeployOperation;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationJobAdapter;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class J2EEDeployAction
extends BaseAction {
    protected void primRun(Shell shell) {
        if (this.isEnabled()) {
            J2EEDeployOperation op = new J2EEDeployOperation(this.selection.toArray());
            WTPOperationJobAdapter jobAdapter = new WTPOperationJobAdapter((WTPOperation)op);
            jobAdapter.setName(J2EEPluginResourceHandler.getString((String)"J2EEDeployOperation_UI_0"));
            IWorkbench workbench = J2EEUIPlugin.getDefault().getWorkbench();
            IProgressService progressService = workbench.getProgressService();
            jobAdapter.setPriority(10);
            progressService.showInDialog(workbench.getActiveWorkbenchWindow().getShell(), (Job)jobAdapter);
            jobAdapter.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection aSelection) {
        super.selectionChanged(action, aSelection);
        action.setEnabled(this.isEnabled());
    }

    public boolean isEnabled() {
        try {
            DeployerRegistry reg = DeployerRegistry.instance();
            List modules = DeployerRegistry.getSelectedModules((Object[])this.selection.toArray());
            int i = 0;
            while (i < modules.size()) {
                EObject module = (EObject)modules.get(i);
                IProject proj = ProjectUtilities.getProject((EObject)module);
                IRuntime runtime = ServerCore.getProjectProperties((IProject)proj).getRuntimeTarget();
                if (proj == null || runtime == null) {
                    return false;
                }
                List visitors = reg.getDeployModuleExtensions(module, runtime);
                if (!visitors.isEmpty()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (RuntimeException e) {
            System.out.println("Deploy Action recovering from problem verifying enablement.");
            e.printStackTrace();
            return false;
        }
    }
}

