/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.application.internal.operations.FlexibleJavaProjectCreationDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.wizard.FlexibleProjectCreationWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class NewModuleGroupEx {
    private IDataModel model;
    protected Combo projectNameCombo = null;
    protected Text moduleNameText = null;
    protected Button newButton = null;
    protected Text serverTargetText;
    private DataModelSynchHelper synchHelper;
    private Composite parentComposite;
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    private static final String PROJECT_NAME = String.valueOf(J2EEUIMessages.getResourceString("32")) + ":";
    private static final String NEW_LABEL = J2EEUIMessages.getResourceString("14");
    private static final String MODULE_NAME = J2EEUIMessages.getResourceString("99");

    public NewModuleGroupEx(Composite parent, int style, IDataModel model) {
        this.model = model;
        this.parentComposite = parent;
        this.synchHelper = new DataModelSynchHelper(model);
        this.buildComposites(parent);
    }

    public void buildComposites(Composite parent) {
        this.createProjectNameGroup(parent);
        this.projectNameCombo.setFocus();
        this.initializeProjectList();
        this.createServerTargetComposite(parent);
        this.addSeperator(parent, 3);
        this.createModuleGroup(parent);
    }

    public void initializeProjectList() {
        IProject[] workspaceProjects = ProjectUtilities.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        int i = 0;
        while (i < workspaceProjects.length) {
            IProject project = workspaceProjects[i];
            try {
                if (project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                    items.add(project.getName());
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        String[] names = new String[items.size()];
        int i2 = 0;
        while (i2 < items.size()) {
            names[i2] = (String)items.get(i2);
            ++i2;
        }
        this.projectNameCombo.setItems(names);
        if (!this.model.isPropertySet("IComponentCreationDataModelProperties.PROJECT_NAME") || this.model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME").length() == 0) {
            IProject selectedProject = this.getSelectedProject();
            if (selectedProject != null) {
                this.projectNameCombo.setText(selectedProject.getName());
                this.model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)selectedProject.getName());
            } else if (names.length > 0) {
                this.projectNameCombo.setText(names[0]);
                this.model.setProperty("IComponentCreationDataModelProperties.PROJECT_NAME", (Object)names[0]);
            }
        } else {
            this.projectNameCombo.add(this.model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"));
            this.projectNameCombo.setText(this.model.getStringProperty("IComponentCreationDataModelProperties.PROJECT_NAME"));
        }
    }

    private void createProjectNameGroup(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText(PROJECT_NAME);
        GridData data = new GridData();
        projectNameLabel.setLayoutData((Object)data);
        this.projectNameCombo = new Combo(parent, 2056);
        data = new GridData(768);
        data.widthHint = 305;
        this.projectNameCombo.setLayoutData((Object)data);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IProject project = ProjectUtilities.getProject((String)NewModuleGroupEx.this.projectNameCombo.getText());
                IRuntime runtime = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget();
                if (runtime != null) {
                    NewModuleGroupEx.this.serverTargetText.setText(runtime.getName());
                }
            }
        });
        this.newButton = new Button(parent, 0);
        this.newButton.setLayoutData((Object)new GridData(768));
        this.newButton.setText(NEW_LABEL);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewModuleGroupEx.this.handleNewProjectSelected();
            }
        });
        this.synchHelper.synchCombo(this.projectNameCombo, "IComponentCreationDataModelProperties.PROJECT_NAME", new Control[]{projectNameLabel});
    }

    private IProject getSelectedProject() {
        IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        StructuredSelection stucturedSelection = (StructuredSelection)selection;
        Object obj = stucturedSelection.getFirstElement();
        if (obj instanceof IProject) {
            return (IProject)obj;
        }
        return null;
    }

    private void handleNewProjectSelected() {
        IDataModel projModel = DataModelFactory.createDataModel((IDataModelProvider)new FlexibleJavaProjectCreationDataModelProvider());
        FlexibleProjectCreationWizard newProjectWizard = new FlexibleProjectCreationWizard(projModel);
        WizardDialog dialog = new WizardDialog(this.parentComposite.getShell(), (IWizard)newProjectWizard);
        if (dialog.open() == 0) {
            String newProjectName = projModel.getStringProperty("IFlexibleProjectCreationDataModelProperties.PROJECT_NAME");
            this.projectNameCombo.add(newProjectName);
            this.projectNameCombo.setText(newProjectName);
            IProject project = ProjectUtilities.getProject((String)this.projectNameCombo.getText());
            IRuntime runtime = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget();
            if (runtime != null) {
                this.serverTargetText.setText(runtime.getName());
            }
        }
    }

    private void createModuleGroup(Composite parent) {
        GridData data = new GridData();
        Label moduleNameLabel = new Label(parent, 0);
        moduleNameLabel.setText(MODULE_NAME);
        this.moduleNameText = new Text(parent, 2048);
        data = new GridData(768);
        data.widthHint = 305;
        this.moduleNameText.setLayoutData((Object)data);
        this.synchHelper.synchText(this.moduleNameText, "IComponentCreationDataModelProperties.COMPONENT_NAME", new Control[0]);
        new Label(parent, 0);
    }

    public void dispose() {
        if (this.synchHelper != null) {
            if (this.model != null) {
                this.model.removeListener((IDataModelListener)this.synchHelper);
            }
            this.synchHelper.dispose();
        }
        this.model = null;
    }

    public String getProjectName() {
        return this.projectNameCombo.getText();
    }

    public void addSeperator(Composite parent, int hSpan) {
        Label separator = new Label(parent, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hSpan;
        separator.setLayoutData((Object)gd);
    }

    protected void createServerTargetComposite(Composite parent) {
        IRuntime runtime;
        IProject project;
        Label label = new Label(parent, 0);
        label.setText(J2EEUIMessages.getResourceString("2"));
        this.serverTargetText = new Text(parent, 2056);
        this.serverTargetText.setLayoutData((Object)new GridData(768));
        new Label(parent, 0);
        String projectName = this.projectNameCombo.getText();
        if (projectName != null && projectName.length() != 0 && (project = ProjectUtilities.getProject((String)projectName)) != null && (runtime = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget()) != null) {
            this.serverTargetText.setText(runtime.getName());
        }
    }
}

