/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.tests.util;

import java.util.Enumeration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.common.WaitForAutoBuildCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.provisional.env.core.context.TransientResourceContext;
import org.eclipse.wst.ws.tests.plugin.TestsPlugin;

public class JUnitUtils {
    public static void syncBuildProject(IProject project, Environment env) throws Exception {
        project.build(6, null);
        WaitForAutoBuildCommand cmd = new WaitForAutoBuildCommand();
        cmd.execute(env);
    }

    private static void copyTestFiles(String pathString, int rootSegmentLength, IFolder destFolder, Environment env) throws Exception {
        Enumeration e = TestsPlugin.getDefault().getBundle().getEntryPaths(pathString);
        while (e.hasMoreElements()) {
            String filePath = (String)e.nextElement();
            if (filePath.endsWith("/")) {
                JUnitUtils.copyTestFiles(filePath, rootSegmentLength, destFolder, env);
                continue;
            }
            Path fileIPath = new Path(filePath);
            FileResourceUtils.copyFile((ResourceContext)new TransientResourceContext(), (Plugin)TestsPlugin.getDefault(), (IPath)fileIPath.removeLastSegments(fileIPath.segmentCount() - rootSegmentLength), (IPath)new Path(filePath).removeFirstSegments(rootSegmentLength), (IPath)destFolder.getFullPath(), (ProgressMonitor)env.getProgressMonitor(), (StatusHandler)env.getStatusHandler());
        }
    }

    public static void copyTestData(String dataSubdirectory, IFolder destFolder, Environment env) throws Exception {
        String pathString = "/data/" + dataSubdirectory;
        JUnitUtils.copyTestFiles(pathString, new Path(pathString).segmentCount(), destFolder, env);
    }
}

