/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.test;

import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.archive.emftests.EarEMFTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.common.CommonPackage;

public class ApplicationTest
extends EarEMFTest {
    private static final CommonFactory COMMONFACTORY = CommonPackage.eINSTANCE.getCommonFactory();

    public ApplicationFactory getInstance() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public ApplicationTest(String name) {
        super(name);
    }

    private void init() throws DuplicateObjectException, ResourceLoadException, FileNotFoundException {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
    }

    public void test_containsSecurityRole() {
        Application objApplication = this.getInstance().createApplication();
        String name = "role1";
        String name2 = "role2";
        boolean retValue = false;
        retValue = objApplication.containsSecurityRole(name);
        ApplicationTest.assertEquals((boolean)retValue, (boolean)false);
        SecurityRole role = COMMONFACTORY.createSecurityRole();
        role.setRoleName(name);
        objApplication.getSecurityRoles().add((Object)role);
        retValue = objApplication.containsSecurityRole(name);
        ApplicationTest.assertEquals((boolean)retValue, (boolean)true);
        retValue = objApplication.containsSecurityRole(name2);
        ApplicationTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_getModule_2() {
        Application objApplication = this.getInstance().createApplication();
        Module module = this.getInstance().createModule();
        String uri = "uri1";
        String altDD = "altDD1";
        module.setUri(uri);
        module.setAltDD(altDD);
        objApplication.getModules().add((Object)module);
        Module retValue = null;
        retValue = objApplication.getModule(uri, altDD);
        ApplicationTest.assertEquals((Object)module, (Object)retValue);
    }

    public void test_getFirstModule() {
        Application objApplication = this.getInstance().createApplication();
        Module module = this.getInstance().createModule();
        Module module2 = this.getInstance().createModule();
        Module module3 = this.getInstance().createModule();
        String uri = "uri1";
        String uri2 = "uri2";
        String altDD = "altDD1";
        String altDD2 = "altDD2";
        module.setUri(uri);
        module.setAltDD(altDD);
        module2.setUri(uri2);
        module2.setAltDD(altDD2);
        module3.setUri(uri2);
        module3.setAltDD(altDD);
        objApplication.getModules().add((Object)module);
        objApplication.getModules().add((Object)module2);
        objApplication.getModules().add((Object)module3);
        Module retValue = null;
        retValue = objApplication.getFirstModule(uri2);
        ApplicationTest.assertEquals((Object)module2, (Object)retValue);
    }

    public void test_getModuleHavingAltDD() {
        Application objApplication = this.getInstance().createApplication();
        Module module = this.getInstance().createModule();
        String uri = "uri1";
        String altDD = "altDD1";
        module.setUri(uri);
        module.setAltDD(altDD);
        objApplication.getModules().add((Object)module);
        Module retValue = null;
        retValue = objApplication.getModuleHavingAltDD(altDD);
        ApplicationTest.assertEquals((Object)module, (Object)retValue);
    }

    public void test_getSecurityRoleNamed() {
        Application objApplication = this.getInstance().createApplication();
        String name = "role1";
        String name2 = "role2";
        SecurityRole retValue = null;
        retValue = objApplication.getSecurityRoleNamed(name);
        ApplicationTest.assertNull((Object)retValue);
        SecurityRole role = COMMONFACTORY.createSecurityRole();
        role.setRoleName(name);
        objApplication.getSecurityRoles().add((Object)role);
        retValue = objApplication.getSecurityRoleNamed(name);
        ApplicationTest.assertEquals((Object)retValue, (Object)role);
        retValue = objApplication.getSecurityRoleNamed(name2);
        ApplicationTest.assertNull((Object)retValue);
    }

    public void test_getVersionID() throws Exception {
        this.init();
        ApplicationResource DD = (ApplicationResource)this.earFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(1);
        this.populateRoot(DD.getRootObject());
        int retValue = 0;
        retValue = DD.getApplication().getVersionID();
        ApplicationTest.assertEquals((int)retValue, (int)14);
        DD.setVersionID(13);
        this.setVersion(1);
        retValue = DD.getApplication().getVersionID();
        ApplicationTest.assertEquals((int)retValue, (int)13);
        DD.setVersionID(12);
        this.setVersion(0);
        retValue = DD.getApplication().getVersionID();
        ApplicationTest.assertEquals((int)retValue, (int)12);
    }

    public void test_getJ2EEVersionID() throws IllegalStateException, ResourceLoadException, DuplicateObjectException, FileNotFoundException {
        this.init();
        ApplicationResource DD = (ApplicationResource)this.earFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(1);
        this.populateRoot(DD.getRootObject());
        int retValue = 0;
        retValue = DD.getApplication().getJ2EEVersionID();
        ApplicationTest.assertEquals((int)retValue, (int)14);
        DD.setVersionID(13);
        this.setVersion(1);
        retValue = DD.getApplication().getJ2EEVersionID();
        ApplicationTest.assertEquals((int)retValue, (int)13);
        DD.setVersionID(12);
        this.setVersion(0);
        retValue = DD.getApplication().getJ2EEVersionID();
        ApplicationTest.assertEquals((int)retValue, (int)12);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new ApplicationTest("test_getVersionID"));
        suite.addTest((Test)new ApplicationTest("test_getJ2EEVersionID"));
        suite.addTest((Test)new ApplicationTest("test_getSecurityRoleNamed"));
        suite.addTest((Test)new ApplicationTest("test_getModuleHavingAltDD"));
        suite.addTest((Test)new ApplicationTest("test_containsSecurityRole"));
        suite.addTest((Test)new ApplicationTest("test_getModule_2"));
        suite.addTest((Test)new ApplicationTest("test_getFirstModule"));
        return suite;
    }
}

