/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFEditingTest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.internal.application.ApplicationPackage;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;
import org.eclipse.jst.j2ee.internal.webapplication.WebapplicationPackage;
import org.eclipse.jst.j2ee.jca.ConnectorResource;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;

public class RarEMFEditTest
extends GeneralEMFEditingTest {
    RARFile rarFile;

    public RarEMFEditTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.RarEMFEditTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new RarEMFEditTest("testRAREdit"));
        return suite;
    }

    public void testRAREdit() throws Exception {
        this.getRar();
        RarEMFEditTest.assertEquals((String)"1.0", (String)this.rarFile.getDeploymentDescriptor().getSpecVersion());
        ConnectorResource DD = (ConnectorResource)this.rarFile.getDeploymentDescriptorResource();
        this.setVersion(1);
        this.setModuleType(2);
        this.editRoot(DD.getRootObject());
        String curDir = AutomatedBVT.baseDirectory;
        String out = String.valueOf(curDir) + "testOutput/EMFModelCreationTests/EditRarEAR";
        this.rarFile.extractTo(out, 126);
        this.rarFile.close();
        String cfr_ignored_0 = String.valueOf(curDir) + "EMFTests/ra.xml";
        String cfr_ignored_1 = String.valueOf(curDir) + out + "/fooRAR/META-INF/ra.xml";
    }

    public void getRar() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "loose_module_workspace/LooseConnector/fooRAR/";
        this.rarFile = this.getArchiveFactory().openRARFile(in);
        RarEMFEditTest.assertTrue((this.rarFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }
}

