/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.util.HashSet;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.EntityResolver;

public class DomComparitor {
    private static EntityResolver entityResolver;
    private static HashSet attributeList;

    public static String compareNodes(Node node1, Node node2) throws Exception {
        Node child1;
        if (node1 == null && node2 == null) {
            return null;
        }
        if (node1 != null && node2 == null || node1 == null && node2 != null) {
            return DomComparitor.nullNodeEncountered(node1, node2);
        }
        if (node1.getNodeType() != node2.getNodeType()) {
            return DomComparitor.mismatch("Node.getNodeType() " + node1.getNodeType() + " " + node2.getNodeType(), node1, node2);
        }
        if (node1.getNodeName() != node2.getNodeName()) {
            return DomComparitor.mismatch("Node.getNodeName() <" + node1.getNodeName() + "> <" + node2.getNodeName() + ">", node1, node2);
        }
        if (node1.getNodeValue() != null || node2.getNodeValue() != null) {
            if (node1.getNodeValue() == null) {
                return DomComparitor.mismatch("Node.getNodeValue() node A is null", node1, node2);
            }
            if (node2.getNodeValue() == null) {
                return DomComparitor.mismatch("Node.getNodeValue() node B is null", node1, node2);
            }
            if (!node1.getNodeValue().equals(node2.getNodeValue())) {
                return DomComparitor.mismatch("Node.getNodeValue() <" + node1.getNodeValue() + "> <" + node2.getNodeValue() + ">", node1, node2);
            }
        } else {
            if (node1.hasAttributes() != node2.hasAttributes()) {
                return DomComparitor.mismatch("Node.hasAttributes() " + node1.hasAttributes() + " " + node2.hasAttributes(), node1, node2);
            }
            if (node1.hasChildNodes() != node2.hasChildNodes()) {
                return DomComparitor.mismatch("Node.hasChildNodes() " + node1.hasChildNodes() + " " + node2.hasChildNodes(), node1, node2);
            }
        }
        switch (node1.getNodeType()) {
            case 3: 
            case 4: {
                CharacterData cdata1 = (CharacterData)node1;
                CharacterData cdata2 = (CharacterData)node2;
                if (cdata1.getData().equals(cdata2.getData())) break;
                return DomComparitor.mismatch("CharacterData.getData() " + cdata1.getData() + " " + cdata2.getData(), node1, node2);
            }
            case 2: {
                Attr attr1 = (Attr)node1;
                Attr attr2 = (Attr)node2;
                if (!attr1.getName().equals(attr2.getName())) {
                    return DomComparitor.mismatch("Attr.getName() " + attr1.getName() + " " + attr2.getName(), node1, node2);
                }
                if (attributeList == null || attributeList.contains(attr1.getName()) || attributeList.contains(attr2.getName())) break;
                if (!attr1.getValue().equals(attr2.getValue())) {
                    return DomComparitor.mismatch("Attr.getValue() " + attr1.getValue() + " " + attr2.getValue(), node1, node2);
                }
                if (attr1.getSpecified() == attr2.getSpecified()) break;
                return DomComparitor.mismatch("Attr.getSpecified() " + attr1.getSpecified() + " " + attr2.getSpecified(), node1, node2);
            }
            case 9: {
                Document doc1 = (Document)node1;
                Document doc2 = (Document)node2;
                String result = DomComparitor.compareNodes(doc1.getDoctype(), doc2.getDoctype());
                if (result == null) break;
                return result;
            }
            case 10: {
                DocumentType docType1 = (DocumentType)node1;
                DocumentType docType2 = (DocumentType)node2;
                if (docType1.getPublicId().equals(docType2.getPublicId())) break;
                return DomComparitor.mismatch("DocumentType.getPublicId() " + docType1.getPublicId() + " " + docType2.getPublicId(), node1, node2);
            }
            case 7: {
                ProcessingInstruction cfr_ignored_0 = (ProcessingInstruction)node1;
                ProcessingInstruction cfr_ignored_1 = (ProcessingInstruction)node2;
                break;
            }
            case 11: {
                DocumentFragment cfr_ignored_2 = (DocumentFragment)node1;
                DocumentFragment cfr_ignored_3 = (DocumentFragment)node2;
                break;
            }
        }
        NamedNodeMap attributes1 = node1.getAttributes();
        NamedNodeMap attributes2 = node2.getAttributes();
        if (attributes1 != null && attributes2 != null) {
            if (attributes1.getLength() != attributes2.getLength()) {
                return DomComparitor.mismatch("getAttributes().getLength() " + attributes1.getLength() + " " + attributes2.getLength(), node1, node2);
            }
            int i = 0;
            while (i < attributes1.getLength()) {
                String results;
                Attr attr1 = (Attr)attributes1.item(i);
                Attr attr2 = (Attr)attributes2.item(i);
                if (!attr1.getName().equals(attr2.getName())) {
                    return DomComparitor.mismatch("Attr.getName() " + attr1.getName() + " " + attr2.getName(), attr1, attr2);
                }
                if (attributeList != null && !attributeList.contains(attr1.getName()) && !attributeList.contains(attr2.getName()) && (results = DomComparitor.compareNodes(attr1, attr2)) != null) {
                    return results;
                }
                ++i;
            }
        } else if (attributes1 != null || attributes2 != null) {
            return DomComparitor.mismatch("getAttributes() null", node1, node2);
        }
        NodeList children1 = node1.getChildNodes();
        NodeList children2 = node2.getChildNodes();
        int count1 = 0;
        int count2 = 0;
        while (count1 < children1.getLength() && count2 < children2.getLength()) {
            child1 = children1.item(count1);
            Node child2 = children2.item(count2);
            if (child1.getNodeType() != child2.getNodeType()) {
                if (child1.getNodeType() == 3 && (child1.getNodeValue() == null || child1.getNodeValue().trim().equals(""))) {
                    ++count1;
                    continue;
                }
                if (child2.getNodeType() == 3 && (child2.getNodeValue() != null || child2.getNodeValue().trim().equals(""))) {
                    ++count2;
                    continue;
                }
            }
            ++count1;
            ++count2;
            String results = DomComparitor.compareNodes(child1, child2);
            if (results == null) continue;
            return results;
        }
        while (count1 < children1.getLength()) {
            child1 = children1.item(count1);
            if (child1.getNodeType() == 3 && child1.getNodeValue() == null || child1.getNodeValue().trim().equals("")) {
                ++count1;
                continue;
            }
            return DomComparitor.nodeNotCompared(child1);
        }
        while (count2 < children2.getLength()) {
            Node child2 = children2.item(count2);
            if (child2.getNodeType() == 3 && child2.getNodeValue() == null || child2.getNodeValue().trim().equals("")) {
                ++count2;
                continue;
            }
            return DomComparitor.nodeNotCompared(child2);
        }
        return null;
    }

    public static String nullNodeEncountered(Node node1, Node node2) {
        String message = "Null node encountered";
        Node nonNullNode = node1 == null ? node2 : node1;
        char source = node1 == null ? (char)'B' : 'A';
        while (nonNullNode != null) {
            message = String.valueOf(message) + source + nonNullNode.getNodeName() + "\n";
            nonNullNode = nonNullNode.getParentNode();
        }
        return message;
    }

    public static String nodeNotCompared(Node node) {
        String message = "Node node compared:";
        while (node != null) {
            message = String.valueOf(message) + node.getNodeName() + "\n";
            node = node.getParentNode();
        }
        return message;
    }

    public static String mismatch(String mismatchtype, Node node1, Node node2) throws Exception {
        String message = "Nodes A and B do not match because of node." + mismatchtype + "\n";
        while (node1 != null && node2 != null) {
            message = String.valueOf(message) + "A:" + node1.getNodeName() + "\n";
            message = String.valueOf(message) + "B:" + node2.getNodeName() + "\n";
            node1 = node1.getParentNode();
            node2 = node2.getParentNode();
        }
        return message;
    }

    public static void main(String[] args) {
    }

    public static EntityResolver getEntityResolver() {
        return entityResolver;
    }

    public static void setEntityResolver(EntityResolver resolver) {
        entityResolver = resolver;
    }
}

