/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.test;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;

public class TestModuleClassLoading
extends TestCase {
    static String testClass = "client.Subtract";
    static /* synthetic */ Class class$0;

    public TestModuleClassLoading() {
    }

    public TestModuleClassLoading(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.TestModuleClassLoading", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.archive.test.TestModuleClassLoading");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void testAddModuleClassLoading() throws Exception {
        String[] files = new String[]{"PROTO.ear", "SEIinAnotherJar.ear", "SEIinWEB-INF_lib_jar.ear"};
        if (files.length == 0) {
            System.out.println("Usage: args specify full path to ear files.");
        }
        int i = 0;
        while (i < files.length) {
            String cfr_ignored_0 = files[i];
            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
            String in = String.valueOf(AutomatedBVT.baseDirectory) + files[i];
            try {
                EARFile earFile = factory.openEARFile(in);
                System.out.println("uri: " + earFile.getURI());
                System.out.println("Testing " + earFile.getURI());
                TestModuleClassLoading.doModules(earFile);
            }
            catch (Exception e) {
                System.out.println(e);
            }
            ++i;
        }
    }

    public static void doModules(EARFile earFile) {
        List modules = earFile.getModuleFiles();
        int i = 0;
        while (i < modules.size()) {
            Archive module = (Archive)modules.get(i);
            System.out.print("\tLooking for class " + testClass + " in module " + module.getURI());
            TestModuleClassLoading.doLoad(module, testClass);
            ++i;
        }
    }

    private static void doLoad(Archive module, String testClass) {
        try {
            JavaClass javaClass = (JavaClass)JavaClassImpl.reflect((String)testClass, (ResourceSet)module.getResourceSet());
            if (!javaClass.isExistingType()) {
                System.out.println("- NOT FOUND - isExistingType returns false.");
            } else {
                System.out.println(" - found: isExistingType returns true.");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

