/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.client.test;

import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.archive.emftests.AppClientEMFTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.internal.client.ClientPackage;

public class ApplicationClientTest
extends AppClientEMFTest {
    public ApplicationClientTest(String name) {
        super(name);
    }

    private void init() throws DuplicateObjectException, ResourceLoadException, FileNotFoundException {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createAppClient();
    }

    private ApplicationClient getInstance() {
        return ClientPackage.eINSTANCE.getClientFactory().createApplicationClient();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new ApplicationClientTest("test_getVersionID"));
        suite.addTest((Test)new ApplicationClientTest("test_getJ2EEVersionID"));
        suite.addTest((Test)new ApplicationClientTest("test_getCallbackHandlerClassName"));
        suite.addTest((Test)new ApplicationClientTest("test_setCallbackHandlerClassName"));
        return suite;
    }

    public void test_getCallbackHandlerClassName() {
        ApplicationClient objApplicationClient = this.getInstance();
        String callBackHandlerName = "TestCallBackHandlerName";
        objApplicationClient.setCallbackHandlerClassName(callBackHandlerName);
        String retValue = "";
        retValue = objApplicationClient.getCallbackHandlerClassName();
        ApplicationClientTest.assertEquals((String)callBackHandlerName, (String)retValue);
    }

    public void test_setCallbackHandlerClassName() {
        ApplicationClient objApplicationClient = this.getInstance();
        String callBackHandlerName = "TestCallBackHandlerName";
        objApplicationClient.setCallbackHandlerClassName(callBackHandlerName);
        String retValue = "";
        retValue = objApplicationClient.getCallbackHandlerClassName();
        ApplicationClientTest.assertEquals((String)callBackHandlerName, (String)retValue);
    }

    public void test_getVersionID() throws Exception {
        this.init();
        ApplicationClientResource DD = (ApplicationClientResource)this.appClientFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(1);
        this.populateRoot(DD.getRootObject());
        int retValue = 0;
        retValue = DD.getApplicationClient().getVersionID();
        ApplicationClientTest.assertEquals((int)retValue, (int)14);
        DD.setVersionID(13);
        this.setVersion(1);
        retValue = DD.getApplicationClient().getVersionID();
        ApplicationClientTest.assertEquals((int)retValue, (int)13);
        DD.setVersionID(12);
        this.setVersion(0);
        retValue = DD.getApplicationClient().getVersionID();
        ApplicationClientTest.assertEquals((int)retValue, (int)12);
    }

    public void test_getJ2EEVersionID() throws Exception {
        this.init();
        ApplicationClientResource DD = (ApplicationClientResource)this.appClientFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(1);
        this.populateRoot(DD.getRootObject());
        int retValue = 0;
        retValue = DD.getApplicationClient().getJ2EEVersionID();
        ApplicationClientTest.assertEquals((int)retValue, (int)14);
        DD.setVersionID(13);
        this.setVersion(1);
        retValue = DD.getApplicationClient().getJ2EEVersionID();
        ApplicationClientTest.assertEquals((int)retValue, (int)13);
        DD.setVersionID(12);
        this.setVersion(0);
        retValue = DD.getApplicationClient().getJ2EEVersionID();
        ApplicationClientTest.assertEquals((int)retValue, (int)12);
    }
}

