/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.impl.JavaRefFactoryImpl;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.internal.ejb.EjbPackage;

public class ContainerManagedEntityTest
extends TestCase {
    private static final EjbFactory EJBFACTORY = EjbPackage.eINSTANCE.getEjbFactory();
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.ejb.test.ContainerManagedEntityTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    private ContainerManagedEntity getInstance() {
        return EJBFACTORY.createContainerManagedEntity();
    }

    public void test_addKeyAttributeName() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        CMPAttribute cmpAttribute = EJBFACTORY.createCMPAttribute();
        EList persistentAttributes = objContainerManagedEntity.getPersistentAttributes();
        persistentAttributes.add(cmpAttribute);
        String attrName = "attr1";
        cmpAttribute.setName(attrName);
        objContainerManagedEntity.addKeyAttributeName(attrName);
        EList keys = objContainerManagedEntity.getKeyAttributes();
        boolean retValue = keys.contains(cmpAttribute);
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_addPersistentAttribute() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        Field aField = JavaRefFactoryImpl.getActiveFactory().createField();
        String name = "attr1";
        aField.setName(name);
        CMPAttribute retValue = null;
        retValue = objContainerManagedEntity.addPersistentAttribute(aField);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
        retValue = objContainerManagedEntity.getPersistentAttribute(name);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
    }

    public void test_addPersistentAttributeName() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        String name = "attr1";
        CMPAttribute retValue = null;
        retValue = objContainerManagedEntity.addPersistentAttributeName(name);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
        retValue = objContainerManagedEntity.getPersistentAttribute(name);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
    }

    public void test_getKeyAttribute() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        CMPAttribute cmpAttribute = EJBFACTORY.createCMPAttribute();
        EList persistentAttributes = objContainerManagedEntity.getPersistentAttributes();
        persistentAttributes.add(cmpAttribute);
        String attrName = "attr1";
        cmpAttribute.setName(attrName);
        objContainerManagedEntity.addKeyAttributeName(attrName);
        CMPAttribute retValue = objContainerManagedEntity.getKeyAttribute(attrName);
        ContainerManagedEntityTest.assertEquals((Object)retValue, (Object)cmpAttribute);
    }

    public void test_getPrimaryKeyAttribute() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        CMPAttribute cmpAttribute = EJBFACTORY.createCMPAttribute();
        EList persistentAttributes = objContainerManagedEntity.getPersistentAttributes();
        persistentAttributes.add(cmpAttribute);
        String attrName = "attr1";
        cmpAttribute.setName(attrName);
        CMPAttribute retValue = objContainerManagedEntity.getPrimaryKeyAttribute();
        ContainerManagedEntityTest.assertNotSame((Object)retValue, (Object)cmpAttribute);
        objContainerManagedEntity.setPrimKeyField(cmpAttribute);
        retValue = objContainerManagedEntity.getPrimaryKeyAttribute();
        ContainerManagedEntityTest.assertEquals((Object)retValue, (Object)cmpAttribute);
    }

    public void test_isContainerManagedEntity() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        boolean retValue = false;
        retValue = objContainerManagedEntity.isContainerManagedEntity();
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_isKeyAttribute() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        CMPAttribute cmpAttribute = EJBFACTORY.createCMPAttribute();
        EList persistentAttributes = objContainerManagedEntity.getPersistentAttributes();
        persistentAttributes.add(cmpAttribute);
        String attrName = "attr1";
        cmpAttribute.setName(attrName);
        boolean retValue = objContainerManagedEntity.isKeyAttribute(cmpAttribute);
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)false);
        objContainerManagedEntity.addKeyAttributeName(attrName);
        retValue = objContainerManagedEntity.isKeyAttribute(cmpAttribute);
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_removePersistentAttribute_2() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        CMPAttribute cmpAttribute = EJBFACTORY.createCMPAttribute();
        EList persistentAttributes = objContainerManagedEntity.getPersistentAttributes();
        persistentAttributes.add(cmpAttribute);
        String attrName = "attr1";
        cmpAttribute.setName(attrName);
        CMPAttribute retValue = objContainerManagedEntity.getPersistentAttribute(attrName);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
        retValue = objContainerManagedEntity.removePersistentAttribute(attrName);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
        retValue = objContainerManagedEntity.getPersistentAttribute(attrName);
        ContainerManagedEntityTest.assertNull((Object)retValue);
    }

    public void test_removePersistentAttribute() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        Field aField = JavaRefFactoryImpl.getActiveFactory().createField();
        String name = "attr1";
        aField.setName(name);
        CMPAttribute retValue = null;
        retValue = objContainerManagedEntity.addPersistentAttribute(aField);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
        retValue = objContainerManagedEntity.getPersistentAttribute(name);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
        retValue = objContainerManagedEntity.removePersistentAttribute(aField);
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
        retValue = objContainerManagedEntity.getPersistentAttribute(name);
        ContainerManagedEntityTest.assertNull((Object)retValue);
    }

    public void test_setPrimKeyField() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        CMPAttribute cmpAttribute = EJBFACTORY.createCMPAttribute();
        EList persistentAttributes = objContainerManagedEntity.getPersistentAttributes();
        persistentAttributes.add(cmpAttribute);
        String attrName = "attr1";
        cmpAttribute.setName(attrName);
        CMPAttribute retValue = objContainerManagedEntity.getPrimKeyField();
        ContainerManagedEntityTest.assertNotSame((Object)retValue, (Object)cmpAttribute);
        objContainerManagedEntity.setPrimKeyField(cmpAttribute);
        retValue = objContainerManagedEntity.getPrimKeyField();
        ContainerManagedEntityTest.assertEquals((Object)retValue, (Object)cmpAttribute);
    }

    public void test_isVersion1_X() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        objContainerManagedEntity.setVersion("1.x");
        boolean retValue = false;
        retValue = objContainerManagedEntity.isVersion1_X();
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)true);
        objContainerManagedEntity.setVersion("2.x");
        retValue = objContainerManagedEntity.isVersion1_X();
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_isVersion2_X() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        objContainerManagedEntity.setVersion("2.x");
        boolean retValue = false;
        retValue = objContainerManagedEntity.isVersion2_X();
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)true);
        objContainerManagedEntity.setVersion("1.x");
        retValue = objContainerManagedEntity.isVersion2_X();
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)false);
    }

    public void test_listPersistentFieldNames() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        CMPAttribute cmpAttribute1 = EJBFACTORY.createCMPAttribute();
        String attrName1 = "attr1";
        cmpAttribute1.setName(attrName1);
        CMPAttribute cmpAttribute2 = EJBFACTORY.createCMPAttribute();
        String attrName2 = "attr2";
        cmpAttribute2.setName(attrName2);
        EList persistentAttributes = objContainerManagedEntity.getPersistentAttributes();
        persistentAttributes.add(cmpAttribute1);
        persistentAttributes.add(cmpAttribute2);
        String[] retValue = null;
        retValue = objContainerManagedEntity.listPersistentFieldNames();
        ContainerManagedEntityTest.assertNotNull((Object)retValue);
        ContainerManagedEntityTest.assertEquals((retValue.length == 2 ? 1 : 0) != 0, (boolean)true);
        ContainerManagedEntityTest.assertEquals((retValue[0] == attrName1 || retValue[1] == attrName1 ? 1 : 0) != 0, (boolean)true);
        ContainerManagedEntityTest.assertEquals((retValue[0] == attrName2 || retValue[1] == attrName2 ? 1 : 0) != 0, (boolean)true);
    }

    public void test_isUnknownPrimaryKey() {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        objContainerManagedEntity.setPrimaryKeyName("java.lang.String");
        boolean retValue = false;
        retValue = objContainerManagedEntity.isUnknownPrimaryKey();
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)false);
        objContainerManagedEntity.setPrimaryKeyName("java.lang.Object");
        retValue = objContainerManagedEntity.isUnknownPrimaryKey();
        ContainerManagedEntityTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_getCMPVersionID() throws IllegalStateException {
        ContainerManagedEntity objContainerManagedEntity = this.getInstance();
        objContainerManagedEntity.setVersion("1.x");
        int retValue = 0;
        retValue = objContainerManagedEntity.getCMPVersionID();
        ContainerManagedEntityTest.assertEquals((int)11, (int)retValue);
        objContainerManagedEntity.setVersion("2.x");
        retValue = objContainerManagedEntity.getCMPVersionID();
        ContainerManagedEntityTest.assertEquals((int)20, (int)retValue);
    }
}

