/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.test;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBRelation;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.ejb.MessageDriven;
import org.eclipse.jst.j2ee.ejb.Relationships;
import org.eclipse.jst.j2ee.ejb.RoleSource;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.test.EjbEMFTestBase;
import org.eclipse.jst.j2ee.internal.common.CommonPackage;

public class EJBJarTest
extends EjbEMFTestBase {
    private static final CommonFactory COMMONFACTORY = CommonPackage.eINSTANCE.getCommonFactory();

    public EJBJarTest(String name) {
        super(name);
    }

    private EJBJar getInstance() {
        return this.getEjbFactory().createEJBJar();
    }

    public void test_EJBJar() {
        EJBJar tmpEJBJar = this.getInstance();
        EJBJarTest.assertNotNull((Object)tmpEJBJar);
    }

    public void test_containsContainerManagedBeans() {
        EJBJar objEJBJar = this.getInstance();
        Session session = this.getEjbFactory().createSession();
        objEJBJar.getEnterpriseBeans().add((Object)session);
        boolean retValue = false;
        retValue = objEJBJar.containsContainerManagedBeans();
        EJBJarTest.assertEquals((boolean)retValue, (boolean)false);
        ContainerManagedEntity entity = this.getEjbFactory().createContainerManagedEntity();
        objEJBJar.getEnterpriseBeans().add((Object)entity);
        retValue = objEJBJar.containsContainerManagedBeans();
        EJBJarTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_containsSecurityRole() {
        EJBJar objEJBJar = this.getInstance();
        AssemblyDescriptor descriptor = this.getEjbFactory().createAssemblyDescriptor();
        objEJBJar.setAssemblyDescriptor(descriptor);
        String securityRoleName = "testRole";
        boolean retValue = false;
        retValue = objEJBJar.containsSecurityRole(securityRoleName);
        EJBJarTest.assertEquals((boolean)retValue, (boolean)false);
        SecurityRole securityRole = CommonPackage.eINSTANCE.getCommonFactory().createSecurityRole();
        securityRole.setRoleName(securityRoleName);
        descriptor.getSecurityRoles().add((Object)securityRole);
        retValue = objEJBJar.containsSecurityRole(securityRoleName);
        EJBJarTest.assertEquals((boolean)retValue, (boolean)true);
    }

    public void test_getBeanManagedBeans() {
        EJBJar objEJBJar = this.getInstance();
        Session session = this.getEjbFactory().createSession();
        objEJBJar.getEnterpriseBeans().add((Object)session);
        List retValue = null;
        retValue = objEJBJar.getBeanManagedBeans();
        EJBJarTest.assertEquals((retValue.size() == 0 ? 1 : 0) != 0, (boolean)true);
        Entity entity = this.getEjbFactory().createEntity();
        objEJBJar.getEnterpriseBeans().add((Object)entity);
        retValue = objEJBJar.getBeanManagedBeans();
        EJBJarTest.assertEquals((retValue.size() == 1 ? 1 : 0) != 0, (boolean)true);
        EJBJarTest.assertEquals(retValue.get(0), (Object)entity);
    }

    public void test_getContainerManagedBeans() {
        EJBJar objEJBJar = this.getInstance();
        Session session = this.getEjbFactory().createSession();
        objEJBJar.getEnterpriseBeans().add((Object)session);
        List retValue = null;
        retValue = objEJBJar.getContainerManagedBeans();
        EJBJarTest.assertEquals((retValue.size() == 0 ? 1 : 0) != 0, (boolean)true);
        ContainerManagedEntity entity = this.getEjbFactory().createContainerManagedEntity();
        objEJBJar.getEnterpriseBeans().add((Object)entity);
        retValue = objEJBJar.getContainerManagedBeans();
        EJBJarTest.assertEquals((retValue.size() == 1 ? 1 : 0) != 0, (boolean)true);
        EJBJarTest.assertEquals(retValue.get(0), (Object)entity);
    }

    public void test_getEJB11ContainerManagedBeans() {
        EJBJar objEJBJar = this.getInstance();
        Session session = this.getEjbFactory().createSession();
        objEJBJar.getEnterpriseBeans().add((Object)session);
        List retValue = null;
        retValue = objEJBJar.getEJB11ContainerManagedBeans();
        EJBJarTest.assertEquals((retValue.size() == 0 ? 1 : 0) != 0, (boolean)true);
        ContainerManagedEntity entity1 = this.getEjbFactory().createContainerManagedEntity();
        objEJBJar.getEnterpriseBeans().add((Object)entity1);
        entity1.setVersion("1.x");
        ContainerManagedEntity entity2 = this.getEjbFactory().createContainerManagedEntity();
        objEJBJar.getEnterpriseBeans().add((Object)entity2);
        entity2.setVersion("2.x");
        retValue = objEJBJar.getEJB11ContainerManagedBeans();
        EJBJarTest.assertEquals((retValue.size() == 1 ? 1 : 0) != 0, (boolean)true);
        EJBJarTest.assertEquals(retValue.get(0), (Object)entity1);
    }

    public void test_getEJB20ContainerManagedBeans() {
        EJBJar objEJBJar = this.getInstance();
        Session session = this.getEjbFactory().createSession();
        objEJBJar.getEnterpriseBeans().add((Object)session);
        List retValue = null;
        retValue = objEJBJar.getEJB20ContainerManagedBeans();
        EJBJarTest.assertEquals((retValue.size() == 0 ? 1 : 0) != 0, (boolean)true);
        ContainerManagedEntity entity1 = this.getEjbFactory().createContainerManagedEntity();
        objEJBJar.getEnterpriseBeans().add((Object)entity1);
        entity1.setVersion("1.x");
        ContainerManagedEntity entity2 = this.getEjbFactory().createContainerManagedEntity();
        objEJBJar.getEnterpriseBeans().add((Object)entity2);
        entity2.setVersion("2.x");
        retValue = objEJBJar.getEJB20ContainerManagedBeans();
        EJBJarTest.assertEquals((retValue.size() == 1 ? 1 : 0) != 0, (boolean)true);
        EJBJarTest.assertEquals(retValue.get(0), (Object)entity2);
    }

    public void test_getMessageDrivenBeans() {
        EJBJar objEJBJar = this.getInstance();
        Session session = this.getEjbFactory().createSession();
        objEJBJar.getEnterpriseBeans().add((Object)session);
        List retValue = null;
        retValue = objEJBJar.getMessageDrivenBeans();
        EJBJarTest.assertEquals((retValue.size() == 0 ? 1 : 0) != 0, (boolean)true);
        MessageDriven messageDriven = this.getEjbFactory().createMessageDriven();
        objEJBJar.getEnterpriseBeans().add((Object)messageDriven);
        retValue = objEJBJar.getMessageDrivenBeans();
        EJBJarTest.assertEquals((retValue.size() == 1 ? 1 : 0) != 0, (boolean)true);
        EJBJarTest.assertEquals(retValue.get(0), (Object)messageDriven);
    }

    public void test_getEjbRelations() {
        EJBJar objEJBJar = this.getInstance();
        Relationships relationships = this.getEjbFactory().createRelationships();
        objEJBJar.setRelationshipList(relationships);
        relationships.setEjbJar(objEJBJar);
        EList ejbRelations = relationships.getEjbRelations();
        List retValue = null;
        retValue = objEJBJar.getEjbRelations();
        EJBJarTest.assertEquals((Object)ejbRelations, (Object)retValue);
    }

    public void test_getEnterpiseBeanFromRef() {
        EJBJar objEJBJar = this.getInstance();
        AssemblyDescriptor descriptor = this.getEjbFactory().createAssemblyDescriptor();
        objEJBJar.setAssemblyDescriptor(descriptor);
        EjbRef ejbRef = COMMONFACTORY.createEjbRef();
        Session session1 = this.getEjbFactory().createSession();
        String name1 = "Name1";
        session1.setName(name1);
        Session session2 = this.getEjbFactory().createSession();
        String name2 = "Name2";
        session2.setName(name2);
        ejbRef.setLink(name2);
        ejbRef.setName("EjbRef_" + name2);
        objEJBJar.getEnterpriseBeans().add((Object)session1);
        objEJBJar.getEnterpriseBeans().add((Object)session2);
        EnterpriseBean retValue = objEJBJar.getEnterpiseBeanFromRef(ejbRef);
        EJBJarTest.assertEquals((Object)session2, (Object)retValue);
    }

    public void test_getEnterpriseBeanNamed() {
        EJBJar objEJBJar = this.getInstance();
        AssemblyDescriptor descriptor = this.getEjbFactory().createAssemblyDescriptor();
        objEJBJar.setAssemblyDescriptor(descriptor);
        Session session1 = this.getEjbFactory().createSession();
        String name1 = "Name1";
        session1.setName(name1);
        Session session2 = this.getEjbFactory().createSession();
        String name2 = "Name2";
        session2.setName(name2);
        objEJBJar.getEnterpriseBeans().add((Object)session1);
        objEJBJar.getEnterpriseBeans().add((Object)session2);
        EnterpriseBean retValue = objEJBJar.getEnterpriseBeanNamed(name2);
        EJBJarTest.assertEquals((Object)session2, (Object)retValue);
    }

    public void test_getEnterpriseBeansWithReference() {
        EJBJar objEJBJar = this.getInstance();
        AssemblyDescriptor descriptor = this.getEjbFactory().createAssemblyDescriptor();
        objEJBJar.setAssemblyDescriptor(descriptor);
        Session session1 = this.getEjbFactory().createSession();
        String name1 = "Name1";
        session1.setName(name1);
        Session session2 = this.getEjbFactory().createSession();
        String name2 = "Name2";
        session2.setName(name2);
        objEJBJar.getEnterpriseBeans().add((Object)session1);
        objEJBJar.getEnterpriseBeans().add((Object)session2);
        JavaClass javaClass1 = JavaRefFactory.eINSTANCE.createClassRef("java.lang.String");
        JavaClass javaClass2 = JavaRefFactory.eINSTANCE.createClassRef("java.util.List");
        session1.setEjbClass(javaClass1);
        session2.setEjbClass(javaClass2);
        List retValue = null;
        retValue = objEJBJar.getEnterpriseBeansWithReference(javaClass1);
        EJBJarTest.assertEquals((retValue.size() == 1 ? 1 : 0) != 0, (boolean)true);
        EJBJarTest.assertEquals((boolean)retValue.contains(session1), (boolean)true);
        session2.setHomeInterface(javaClass1);
        retValue = objEJBJar.getEnterpriseBeansWithReference(javaClass1);
        EJBJarTest.assertEquals((retValue.size() == 2 ? 1 : 0) != 0, (boolean)true);
        EJBJarTest.assertEquals((boolean)retValue.contains(session1), (boolean)true);
        EJBJarTest.assertEquals((boolean)retValue.contains(session2), (boolean)true);
    }

    public void test_getEnterpriseBeanWithReference() {
        EJBJar objEJBJar = this.getInstance();
        AssemblyDescriptor descriptor = this.getEjbFactory().createAssemblyDescriptor();
        objEJBJar.setAssemblyDescriptor(descriptor);
        Session session1 = this.getEjbFactory().createSession();
        String name1 = "Name1";
        session1.setName(name1);
        Session session2 = this.getEjbFactory().createSession();
        String name2 = "Name2";
        session2.setName(name2);
        objEJBJar.getEnterpriseBeans().add((Object)session1);
        objEJBJar.getEnterpriseBeans().add((Object)session2);
        JavaClass javaClass1 = JavaRefFactory.eINSTANCE.createClassRef("java.lang.String");
        session1.setEjbClass(javaClass1);
        session2.setEjbClass(javaClass1);
        EnterpriseBean retValue = null;
        retValue = objEJBJar.getEnterpriseBeanWithReference(javaClass1);
        EJBJarTest.assertEquals((Object)retValue, (Object)session1);
    }

    public void test_getSessionBeans() {
        EJBJar objEJBJar = this.getInstance();
        MessageDriven messageDriven = this.getEjbFactory().createMessageDriven();
        objEJBJar.getEnterpriseBeans().add((Object)messageDriven);
        List retValue = null;
        retValue = objEJBJar.getSessionBeans();
        EJBJarTest.assertEquals((retValue.size() == 0 ? 1 : 0) != 0, (boolean)true);
        Session session = this.getEjbFactory().createSession();
        objEJBJar.getEnterpriseBeans().add((Object)session);
        retValue = objEJBJar.getSessionBeans();
        EJBJarTest.assertEquals((retValue.size() == 1 ? 1 : 0) != 0, (boolean)true);
        EJBJarTest.assertEquals((boolean)retValue.contains(session), (boolean)true);
    }

    public void test_getVersionID() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(3);
        this.populateRoot(DD.getRootObject());
        int retValue = 0;
        retValue = DD.getEJBJar().getVersionID();
        EJBJarTest.assertEquals((int)retValue, (int)21);
        DD.setVersionID(13);
        this.setVersion(1);
        retValue = DD.getEJBJar().getVersionID();
        EJBJarTest.assertEquals((int)retValue, (int)20);
        DD.setVersionID(12);
        this.setVersion(0);
        retValue = DD.getEJBJar().getVersionID();
        EJBJarTest.assertEquals((int)retValue, (int)11);
    }

    public void test_getJ2EEVersionID() throws Exception {
        this.init();
        EJBResource DD = (EJBResource)this.ejbFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(3);
        this.populateRoot(DD.getRootObject());
        int retValue = 0;
        retValue = DD.getEJBJar().getJ2EEVersionID();
        EJBJarTest.assertEquals((int)retValue, (int)14);
        DD.setVersionID(13);
        this.setVersion(1);
        retValue = DD.getEJBJar().getJ2EEVersionID();
        EJBJarTest.assertEquals((int)retValue, (int)13);
        DD.setVersionID(12);
        this.setVersion(0);
        retValue = DD.getEJBJar().getJ2EEVersionID();
        EJBJarTest.assertEquals((int)retValue, (int)12);
    }

    public void test_getEJBRelation() {
        EJBJar objEJBJar = this.getInstance();
        Relationships relationships = this.getEjbFactory().createRelationships();
        objEJBJar.setRelationshipList(relationships);
        relationships.setEjbJar(objEJBJar);
        EJBRelation relation = this.getEjbFactory().createEJBRelation();
        String aRelationName = "Relation1";
        relation.setName(aRelationName);
        relationships.getEjbRelations().add((Object)relation);
        EJBRelation retValue = null;
        retValue = objEJBJar.getEJBRelation(aRelationName);
        EJBJarTest.assertEquals((Object)retValue, (Object)relation);
    }

    public void test_getEJBRelationsForSource() {
        EJBJar objEJBJar = this.getInstance();
        Relationships relationships = this.getEjbFactory().createRelationships();
        objEJBJar.setRelationshipList(relationships);
        relationships.setEjbJar(objEJBJar);
        EJBRelation relation = this.getEjbFactory().createEJBRelation();
        String aRelationName = "Relation1";
        relation.setName(aRelationName);
        EJBRelationshipRole role1 = this.getEjbFactory().createEJBRelationshipRole();
        EJBRelationshipRole role2 = this.getEjbFactory().createEJBRelationshipRole();
        EList roleList = relation.getRelationshipRoles();
        roleList.add(role1);
        roleList.add(role2);
        ContainerManagedEntity entity = this.getEjbFactory().createContainerManagedEntity();
        ContainerManagedEntity targetEntity = this.getEjbFactory().createContainerManagedEntity();
        RoleSource roleSource = this.getEjbFactory().createRoleSource();
        roleSource.setEntityBean(entity);
        roleSource.setRole(role1);
        role1.setSource(roleSource);
        RoleSource targetRoleSource = this.getEjbFactory().createRoleSource();
        targetRoleSource.setEntityBean(targetEntity);
        targetRoleSource.setRole(role2);
        role2.setSource(targetRoleSource);
        List retValue = null;
        retValue = objEJBJar.getEJBRelationsForSource(entity);
        EJBJarTest.assertNotNull((Object)retValue);
        EJBJarTest.assertEquals((int)retValue.size(), (int)1);
        EJBJarTest.assertEquals((boolean)retValue.contains(relation), (boolean)true);
    }

    public void test_getEJBRelationshipRolesForType() {
        EJBJar objEJBJar = this.getInstance();
        Relationships relationships = this.getEjbFactory().createRelationships();
        objEJBJar.setRelationshipList(relationships);
        relationships.setEjbJar(objEJBJar);
        EJBRelation relation = this.getEjbFactory().createEJBRelation();
        String aRelationName = "Relation1";
        relation.setName(aRelationName);
        EJBRelationshipRole role1 = this.getEjbFactory().createEJBRelationshipRole();
        EJBRelationshipRole role2 = this.getEjbFactory().createEJBRelationshipRole();
        EList roleList = relation.getRelationshipRoles();
        roleList.add(role1);
        roleList.add(role2);
        ContainerManagedEntity entity = this.getEjbFactory().createContainerManagedEntity();
        ContainerManagedEntity targetEntity = this.getEjbFactory().createContainerManagedEntity();
        RoleSource roleSource = this.getEjbFactory().createRoleSource();
        roleSource.setEntityBean(entity);
        roleSource.setRole(role1);
        role1.setSource(roleSource);
        RoleSource targetRoleSource = this.getEjbFactory().createRoleSource();
        targetRoleSource.setEntityBean(targetEntity);
        targetRoleSource.setRole(role2);
        role2.setSource(targetRoleSource);
        List retValue = null;
        retValue = objEJBJar.getEJBRelationshipRolesForType(targetEntity);
        EJBJarTest.assertNotNull((Object)retValue);
        EJBJarTest.assertEquals((int)retValue.size(), (int)1);
        EJBJarTest.assertEquals((boolean)retValue.contains(relation), (boolean)true);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EJBJarTest("test_EJBJar"));
        suite.addTest((Test)new EJBJarTest("test_containsContainerManagedBeans"));
        suite.addTest((Test)new EJBJarTest("test_containsSecurityRole"));
        suite.addTest((Test)new EJBJarTest("test_getBeanManagedBeans"));
        suite.addTest((Test)new EJBJarTest("test_getContainerManagedBeans"));
        suite.addTest((Test)new EJBJarTest("test_getEJB11ContainerManagedBeans"));
        suite.addTest((Test)new EJBJarTest("test_getEJB20ContainerManagedBeans"));
        suite.addTest((Test)new EJBJarTest("test_getMessageDrivenBeans"));
        suite.addTest((Test)new EJBJarTest("test_getEjbRelations"));
        suite.addTest((Test)new EJBJarTest("test_getEnterpiseBeanFromRef"));
        suite.addTest((Test)new EJBJarTest("test_getEnterpriseBeanNamed"));
        suite.addTest((Test)new EJBJarTest("test_getEnterpriseBeansWithReference"));
        suite.addTest((Test)new EJBJarTest("test_getEnterpriseBeanWithReference"));
        suite.addTest((Test)new EJBJarTest("test_getSessionBeans"));
        suite.addTest((Test)new EJBJarTest("test_getVersionID"));
        suite.addTest((Test)new EJBJarTest("test_getJ2EEVersionID"));
        suite.addTest((Test)new EJBJarTest("test_getEJBRelation"));
        suite.addTest((Test)new EJBJarTest("test_getEJBRelationsForSource"));
        suite.addTest((Test)new EJBJarTest("test_getEJBRelationshipRolesForType"));
        return suite;
    }
}

