/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.frameworks.internal.ui.ListenerList;
import org.eclipse.wst.common.frameworks.internal.ui.TimerQueue;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;

public class Timer {
    protected ListenerList listenerList = new ListenerList();
    boolean eventQueued = false;
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    private Runnable doPostEvent;
    long expirationTime;
    Timer nextTimer;
    boolean running;

    public Timer(int delay, ActionListener listener) {
        this.delay = delay;
        this.initialDelay = delay;
        this.doPostEvent = new DoPostEvent();
        if (listener != null) {
            this.addActionListener(listener);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(listener);
    }

    synchronized void cancelEvent() {
        this.eventQueued = false;
    }

    protected void fireActionPerformed(ActionEvent e) {
        ActionListener[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 1;
        while (i >= 0) {
            listeners[i].actionPerformed(e);
            --i;
        }
    }

    public int getDelay() {
        return this.delay;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    synchronized void post() {
        if (!this.eventQueued) {
            this.eventQueued = true;
            Display.getDefault().asyncExec(this.doPostEvent);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(listener);
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void setCoalesce(boolean flag) {
        this.coalesce = flag;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            String msg = WTPCommonUIResourceHandler.getString("Timer_UI_0", new Object[]{Integer.toString(delay)});
            throw new IllegalArgumentException(msg);
        }
        this.delay = delay;
    }

    public void setInitialDelay(int initialDelay) {
        if (initialDelay < 0) {
            String msg = WTPCommonUIResourceHandler.getString("Timer_UI_1", new Object[]{Integer.toString(initialDelay)});
            throw new IllegalArgumentException(msg);
        }
        this.initialDelay = initialDelay;
    }

    public void setRepeats(boolean flag) {
        this.repeats = flag;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.getInitialDelay());
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.cancelEvent();
    }

    TimerQueue timerQueue() {
        return TimerQueue.singleton();
    }

    protected Object getSource() {
        return this;
    }

    class DoPostEvent
    implements Runnable {
        DoPostEvent() {
        }

        public void run() {
            if (Timer.this.eventQueued) {
                Timer.this.fireActionPerformed(new ActionEvent(Timer.this.getSource(), 0, null));
                Timer.this.cancelEvent();
            }
        }

        Timer getTimer() {
            return Timer.this;
        }
    }
}

