/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementManager;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WizardPageElement;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WizardPageExtensionManager;
import org.eclipse.wst.common.frameworks.internal.operations.FailSafeComposedOperation;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.ui.ErrorDialog;
import org.eclipse.wst.common.frameworks.internal.ui.IExtendedPageHandler;
import org.eclipse.wst.common.frameworks.internal.ui.IExtendedWizardPage;
import org.eclipse.wst.common.frameworks.internal.ui.UIOperationHandler;
import org.eclipse.wst.common.frameworks.internal.ui.WTPCommonUIResourceHandler;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.common.frameworks.internal.ui.WTPWizardPage;

public abstract class WTPWizard
extends Wizard {
    private IExtendedWizardPage[] extendedPages = null;
    private IExtendedPageHandler[] extendedPageHandlers = null;
    protected WTPOperationDataModel model;

    public WTPWizard(WTPOperationDataModel model) {
        this.model = model;
    }

    public WTPWizard() {
        this.model = this.createDefaultModel();
    }

    protected abstract WTPOperationDataModel createDefaultModel();

    public String getWizardID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void createPageControls(Composite pageContainer) {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            block5: {
                block4: {
                    if (this.isExtendedPage(pages[i])) {
                        try {
                            pages[i].createControl(pageContainer);
                            break block4;
                        }
                        catch (Exception e) {
                            Logger.getLogger().logError((Throwable)e);
                            break block5;
                        }
                    }
                    pages[i].createControl(pageContainer);
                }
                Assert.isNotNull((Object)pages[i].getControl());
            }
            ++i;
        }
    }

    protected boolean isExtendedPage(IWizardPage page) {
        int i = 0;
        while (this.extendedPages != null && i < this.extendedPages.length) {
            if (page == this.extendedPages[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void addPages() {
        this.doAddPages();
        this.addExtensionPages();
    }

    protected void doAddPages() {
    }

    private void addExtensionPages() {
        String wizardID = this.getWizardID();
        WizardPageElement wizElement = null;
        if (wizardID == null) {
            return;
        }
        WizardPageElement[] elements = WizardPageExtensionManager.getInstance().getPageElements(this.getWizardID());
        IExtendedWizardPage[] extendedPagesLocal = null;
        IExtendedPageHandler extendedPageHandler = null;
        ArrayList<IExtendedWizardPage> extendedPagesList = new ArrayList<IExtendedWizardPage>();
        ArrayList<IExtendedPageHandler> extendedPageHandlerList = new ArrayList<IExtendedPageHandler>();
        int i = 0;
        while (i < elements.length) {
            wizElement = elements[i];
            try {
                extendedPagesLocal = wizElement.createPageGroup(this.model);
                if (extendedPagesLocal != null) {
                    int j = 0;
                    while (j < extendedPagesLocal.length) {
                        this.addPage(extendedPagesLocal[j]);
                        extendedPagesList.add(extendedPagesLocal[j]);
                        ++j;
                    }
                }
                if ((extendedPageHandler = wizElement.createPageHandler(this.model)) != null && !extendedPageHandlerList.contains(extendedPageHandler)) {
                    extendedPageHandlerList.add(extendedPageHandler);
                }
            }
            catch (RuntimeException runtime) {
                Logger.getLogger().logError(WTPCommonUIResourceHandler.getString("ExtendableWizard_UI_0", new Object[]{wizElement.getPluginID(), wizElement.pageGroupID}));
                Logger.getLogger().logError((Throwable)runtime);
            }
            ++i;
        }
        this.extendedPages = new IExtendedWizardPage[extendedPagesList.size()];
        i = 0;
        while (i < this.extendedPages.length) {
            this.extendedPages[i] = (IExtendedWizardPage)extendedPagesList.get(i);
            ++i;
        }
        this.extendedPageHandlers = new IExtendedPageHandler[extendedPageHandlerList.size()];
        i = 0;
        while (i < this.extendedPageHandlers.length) {
            this.extendedPageHandlers[i] = (IExtendedPageHandler)extendedPageHandlerList.get(i);
            ++i;
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IExtendedWizardPage extendedWizardPage;
        IWizardPage expectedPage = super.getNextPage(page);
        if (expectedPage instanceof IExtendedWizardPage && !EnablementManager.INSTANCE.getIdentifier((extendedWizardPage = (IExtendedWizardPage)expectedPage).getGroupID(), this.getModel().getTargetProject()).isEnabled()) {
            return this.getNextPage(expectedPage);
        }
        String expectedPageName = expectedPage == null ? null : expectedPage.getName();
        String nextPageName = null;
        int i = 0;
        while (this.extendedPageHandlers != null && i < this.extendedPageHandlers.length) {
            nextPageName = this.extendedPageHandlers[i].getNextPage(page.getName(), expectedPageName);
            if (nextPageName != null) {
                if (nextPageName.equals("IExtendedPageHandler.SKIP_PAGE")) {
                    return this.getNextPage(expectedPage);
                }
                if (nextPageName.startsWith("IExtendedPageHandler.PAGE_AFTER")) {
                    String tempNextPageName = nextPageName.substring("IExtendedPageHandler.PAGE_AFTER".length());
                    IWizardPage tempNextPage = this.getPage(tempNextPageName);
                    return tempNextPage == null ? null : super.getNextPage(tempNextPage);
                }
                return this.getPage(nextPageName);
            }
            ++i;
        }
        return expectedPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage expectedPage = super.getPreviousPage(page);
        String expectedPageName = expectedPage == null ? null : expectedPage.getName();
        String previousPageName = null;
        int i = 0;
        while (this.extendedPageHandlers != null && i < this.extendedPageHandlers.length) {
            previousPageName = this.extendedPageHandlers[i].getPreviousPage(page.getName(), expectedPageName);
            if (previousPageName != null) {
                if (previousPageName.equals("IExtendedPageHandler.SKIP_PAGE")) {
                    return this.getPreviousPage(expectedPage);
                }
                if (previousPageName.startsWith("IExtendedPageHandler.PAGE_AFTER")) {
                    String tempPreviousPageName = previousPageName.substring("IExtendedPageHandler.PAGE_AFTER".length());
                    IWizardPage tempPreviousPage = this.getPage(tempPreviousPageName);
                    return tempPreviousPage == null ? null : super.getPreviousPage(tempPreviousPage);
                }
                return this.getPage(previousPageName);
            }
            ++i;
        }
        return expectedPage;
    }

    public boolean canFinish() {
        if (!super.canFinish() || !this.model.isValid()) {
            return false;
        }
        int i = 0;
        while (this.extendedPages != null && i < this.extendedPages.length) {
            if (!this.extendedPages[i].canPageFinish()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void resetAfterFinishError() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            WTPWizardPage wtpPage = (WTPWizardPage)pages[i];
            wtpPage.validatePage(true);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean performFinish() {
        boolean bl;
        WTPOperation op = null;
        boolean wasSuccessful = false;
        try {
            this.model.setProperty("WTPOperationDataModel.UI_OPERATION_HANLDER", (Object)new UIOperationHandler(this.getShell()));
            if (this.prePerformFinish()) {
                this.storeDefaultSettings();
                op = this.createOperation();
                if (!this.model.getBooleanProperty("WTPOperationDataModel.RUN_OPERATION")) {
                    this.model.setProperty("WTPOperationDataModel.CACHED_DELAYED_OPERATION", (Object)op);
                    boolean bl2 = wasSuccessful = this.isSuccessfulFinish(op);
                    Object var5_7 = null;
                    if (wasSuccessful) return bl2;
                    this.resetAfterFinishError();
                    return bl2;
                }
                if (op != null) {
                    IRunnableWithProgress runnable = WTPUIPlugin.getRunnableWithProgress((IHeadlessRunnableWithProgress)op);
                    try {
                        this.getContainer().run(this.runForked(), this.isCancelable(), runnable);
                        this.postPerformFinish();
                    }
                    catch (InvocationTargetException e) {
                        Logger.getLogger().logError((Throwable)e);
                        ErrorDialog.openError(this.getShell(), WTPCommonUIResourceHandler.getString("WTPWizard_UI_0", new Object[]{this.getWindowTitle()}), WTPCommonUIResourceHandler.getString("WTPWizard_UI_1", new Object[]{this.getWindowTitle()}), e, 0, false);
                        boolean bl3 = wasSuccessful = false;
                        Object var5_8 = null;
                        if (wasSuccessful) return bl3;
                        this.resetAfterFinishError();
                        return bl3;
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger().logError((Throwable)e);
                        boolean bl4 = wasSuccessful = false;
                        Object var5_9 = null;
                        if (wasSuccessful) return bl4;
                        this.resetAfterFinishError();
                        return bl4;
                    }
                }
            }
            bl = wasSuccessful = this.isSuccessfulFinish(op);
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (wasSuccessful) throw throwable;
            this.resetAfterFinishError();
            throw throwable;
        }
        Object var5_10 = null;
        if (wasSuccessful) return bl;
        this.resetAfterFinishError();
        return bl;
    }

    protected boolean isSuccessfulFinish(WTPOperation op) {
        return op != null;
    }

    protected boolean prePerformFinish() {
        return true;
    }

    protected void postPerformFinish() throws InvocationTargetException {
    }

    protected void storeDefaultSettings() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            this.storeDefaultSettings(pages[i], i);
            ++i;
        }
    }

    protected void storeDefaultSettings(IWizardPage page, int pageIndex) {
        if (page instanceof WTPWizardPage) {
            ((WTPWizardPage)page).storeDefaultSettings();
        }
    }

    protected boolean isCancelable() {
        return false;
    }

    protected boolean runForked() {
        return false;
    }

    protected WTPOperation createBaseOperation() {
        return this.model.getDefaultOperation();
    }

    protected final WTPOperation createOperation() {
        WTPOperation baseOperation = this.createBaseOperation();
        WTPOperation composedOperation = null;
        int i = 0;
        while (this.extendedPages != null && i < this.extendedPages.length) {
            WTPOperation op = this.extendedPages[i].createOperation();
            if (op != null) {
                if (composedOperation == null) {
                    composedOperation = new FailSafeComposedOperation();
                    composedOperation.append(baseOperation);
                }
                composedOperation.append(op);
            }
            ++i;
        }
        return composedOperation != null ? composedOperation : baseOperation;
    }

    public WTPOperationDataModel getModel() {
        return this.model;
    }

    public void dispose() {
        super.dispose();
        if (this.model != null) {
            this.model.dispose();
        }
    }

    public void addPage(IWizardPage page) {
        List pagesToSkip;
        if (this.model.isProperty("WTPWizardSkipPageDataModel.SKIP_PAGES") && page.getName() != null && (pagesToSkip = (List)this.model.getProperty("WTPWizardSkipPageDataModel.SKIP_PAGES")) != null && pagesToSkip.contains(page.getName())) {
            return;
        }
        super.addPage(page);
    }
}

