/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.provisional.env.core.uri;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.uri.RelativeScheme;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URI;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIException;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIFilter;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIScheme;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIVisitor;

public class RelativeURI
implements URI {
    protected String uri_;

    public RelativeURI(String uri) {
        this.uri_ = uri;
    }

    public URI append(URI relativeURI) throws URIException {
        if (!relativeURI.isRelative()) {
            MessageUtils msg = new MessageUtils("org.eclipse.wst.command.env.core.environment", new Dummy());
            throw new URIException(new SimpleStatus("RelativeURI", msg.getMessage("MSG_URI_NOT_RELATIVE", new Object[]{relativeURI.toString()}), 4));
        }
        String newURI = String.valueOf(this.uri_) + "/" + relativeURI.toString();
        return this.getURIScheme().newURI(newURI);
    }

    public File asFile() {
        return null;
    }

    public String asString() {
        return this.uri_;
    }

    public String toString() {
        return this.uri_;
    }

    public URL asURL() throws URIException {
        URL url = null;
        try {
            url = new URL(this.uri_);
        }
        catch (MalformedURLException exc) {
            throw new URIException(new SimpleStatus("RelativeURI", exc.getMessage(), 4), this);
        }
        return url;
    }

    public void erase() throws URIException {
    }

    public InputStream getInputStream() throws URIException {
        return null;
    }

    public OutputStream getOutputStream() throws URIException {
        return null;
    }

    public URIScheme getURIScheme() {
        return new RelativeScheme();
    }

    public boolean isAvailableAsFile() {
        return false;
    }

    public boolean isAvailableAsURL() {
        return true;
    }

    public boolean isHierarchical() {
        return true;
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isPresent() {
        return false;
    }

    public boolean isReadable() {
        return false;
    }

    public boolean isRelative() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public URI[] list() throws URIException {
        return new URI[0];
    }

    public URI[] list(URIFilter uriFilter) throws URIException {
        return new URI[0];
    }

    public URI parent() throws URIException {
        int lastSlash = this.uri_.lastIndexOf(47);
        int firstSlash = this.uri_.indexOf(47);
        if (lastSlash == -1 || firstSlash == -1) {
            return null;
        }
        return this.getURIScheme().newURI(this.uri_.substring(0, lastSlash));
    }

    public void rename(URI newURI) throws URIException {
        this.uri_ = newURI.toString();
    }

    public void touchFolder() throws URIException {
    }

    public void touchLeaf() throws URIException {
    }

    public void visit(URIVisitor uriVisitor, URIFilter uriFilter) throws URIException {
        boolean continueVisit = true;
        if (uriFilter.accepts(this)) {
            continueVisit = uriVisitor.visit(this);
        }
        URI[] children = this.list();
        int index = 0;
        while (index < children.length && continueVisit) {
            children[index].visit(uriVisitor, uriFilter);
            ++index;
        }
    }

    public void visit(URIVisitor uriVisitor) throws URIException {
        boolean continueVisit = uriVisitor.visit(this);
        URI[] children = this.list();
        int index = 0;
        while (index < children.length && continueVisit) {
            children[index].visit(uriVisitor);
            ++index;
        }
    }

    private class Dummy {
        Dummy() {
        }
    }
}

