/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.wst.common.navigator.internal.actions.CommonWizardDescriptor;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.RegistryReader;

public class CommonWizardRegistry {
    public static final String WIZARD_TYPE_NEW = "new";
    public static final String WIZARD_TYPE_IMPORT = "import";
    public static final String WIZARD_TYPE_EXPORT = "export";
    private static final CommonWizardRegistry INSTANCE = new CommonWizardRegistry();
    private static boolean isInitialized = false;
    private static final String[] NO_DESCRIPTORS = new String[0];
    private Map commonWizardDescriptors = new HashMap();

    public void init() {
        new CommonWizardRegistryReader().readRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonWizardRegistry getInstance() {
        if (isInitialized) {
            return INSTANCE;
        }
        CommonWizardRegistry commonWizardRegistry = INSTANCE;
        synchronized (commonWizardRegistry) {
            if (!isInitialized) {
                INSTANCE.init();
                isInitialized = true;
            }
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommonWizardDescriptor(CommonWizardDescriptor aDesc) {
        if (aDesc == null) {
            return;
        }
        Map map = this.commonWizardDescriptors;
        synchronized (map) {
            HashSet<CommonWizardDescriptor> descriptors = (HashSet<CommonWizardDescriptor>)this.commonWizardDescriptors.get(aDesc.getType());
            if (descriptors == null) {
                descriptors = new HashSet<CommonWizardDescriptor>();
                this.commonWizardDescriptors.put(aDesc.getType(), descriptors);
            }
            if (!descriptors.contains(aDesc)) {
                descriptors.add(aDesc);
            }
        }
    }

    public String[] getEnabledCommonWizardDescriptorIds(Object anElement, String aType) {
        Set commonDescriptors = (Set)this.commonWizardDescriptors.get(aType);
        if (commonDescriptors == null) {
            return NO_DESCRIPTORS;
        }
        ArrayList<String> descriptorIds = new ArrayList<String>();
        Iterator commonWizardDescriptorsItr = commonDescriptors.iterator();
        while (commonWizardDescriptorsItr.hasNext()) {
            CommonWizardDescriptor descriptor = (CommonWizardDescriptor)commonWizardDescriptorsItr.next();
            if (!descriptor.isEnabledFor(anElement)) continue;
            descriptorIds.add(descriptor.getWizardId());
        }
        String[] wizardIds = new String[descriptorIds.size()];
        return descriptorIds.toArray(wizardIds);
    }

    public String[] getEnabledCommonWizardDescriptorIds(IStructuredSelection aStructuredSelection, String aType) {
        Set commonDescriptors = (Set)this.commonWizardDescriptors.get(aType);
        if (commonDescriptors == null) {
            return NO_DESCRIPTORS;
        }
        ArrayList<String> descriptorIds = new ArrayList<String>();
        Iterator commonWizardDescriptorsItr = commonDescriptors.iterator();
        while (commonWizardDescriptorsItr.hasNext()) {
            CommonWizardDescriptor descriptor = (CommonWizardDescriptor)commonWizardDescriptorsItr.next();
            if (!descriptor.isEnabledFor(aStructuredSelection)) continue;
            descriptorIds.add(descriptor.getWizardId());
        }
        String[] wizardIds = new String[descriptorIds.size()];
        return descriptorIds.toArray(wizardIds);
    }

    class CommonWizardRegistryReader
    extends RegistryReader {
        private static final String COMMON_WIZARD = "commonWizard";

        CommonWizardRegistryReader() {
            super(WorkbenchNavigatorPlugin.PLUGIN_ID, COMMON_WIZARD);
        }

        protected boolean readElement(IConfigurationElement anElement) {
            if (COMMON_WIZARD.equals(anElement.getName())) {
                try {
                    CommonWizardRegistry.this.addCommonWizardDescriptor(new CommonWizardDescriptor(anElement));
                    return true;
                }
                catch (WorkbenchException e) {
                    WorkbenchNavigatorPlugin.log("Unable to create common wizard descriptor.", e.getStatus());
                }
            }
            return false;
        }
    }
}

