/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.perspective;

import java.util.Hashtable;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.util.HTMLUtils;

public abstract class Tool {
    protected ToolManager toolManager_;
    private String enabledImageLink_;
    private String highlightedImageLink_;
    private String alt_;
    protected int toolId_;
    protected byte toolType_;

    public Tool(ToolManager toolManager, String enabledImageLink, String highlightedImageLink, String alt, byte toolType) {
        this.toolManager_ = toolManager;
        this.enabledImageLink_ = enabledImageLink;
        this.highlightedImageLink_ = highlightedImageLink;
        this.alt_ = alt;
        this.toolId_ = this.toolManager_.addTool(this);
        this.toolType_ = toolType;
    }

    public abstract String getSelectToolActionHref(boolean var1);

    public String getSelectToolActionTarget() {
        return "perspective_workarea";
    }

    private final void generateOnMouseValue(StringBuffer value, HttpServletResponse response, String fullImageLink) {
        value.append("src='").append(response.encodeURL(fullImageLink)).append('\'');
    }

    public String renderTool(HttpServletResponse response, Controller controller) {
        Hashtable<String, String> jsImageProperties = new Hashtable<String, String>();
        StringBuffer propertyValue = new StringBuffer();
        String fullEnabledImageLink = controller.getPathWithContext(this.enabledImageLink_);
        this.generateOnMouseValue(propertyValue, response, fullEnabledImageLink);
        int propertyValueLength = propertyValue.length();
        jsImageProperties.put("class", "normal");
        jsImageProperties.put("onMouseOut", propertyValue.append(";mouseout(this)").toString());
        propertyValue.delete(propertyValueLength, propertyValue.length());
        jsImageProperties.put("onMouseUp", propertyValue.append(";mouseup(this)").toString());
        propertyValue.setLength(0);
        this.generateOnMouseValue(propertyValue, response, controller.getPathWithContext(this.highlightedImageLink_));
        propertyValueLength = propertyValue.length();
        jsImageProperties.put("onMouseOver", propertyValue.append(";mouseover(this)").toString());
        propertyValue.delete(propertyValueLength, propertyValue.length());
        jsImageProperties.put("onMouseDOwn", propertyValue.append(";mousedown(this)").toString());
        String imageTag = HTMLUtils.getHTMLImageTag(response, fullEnabledImageLink, this.alt_, "16", "16", jsImageProperties);
        return HTMLUtils.getHTMLLinkTag(response, controller.getPathWithContext(this.getSelectToolActionHref(false)), this.getSelectToolActionTarget(), null, imageTag, null);
    }

    public final ToolManager getToolManager() {
        return this.toolManager_;
    }

    public final int getToolId() {
        return this.toolId_;
    }

    public final byte getToolType() {
        return this.toolType_;
    }

    public final String getEnabledImageLink() {
        return this.enabledImageLink_;
    }

    public final String getHighlightedImageLink() {
        return this.highlightedImageLink_;
    }

    public final String getAltText() {
        return this.alt_;
    }

    public abstract String getFormLink();

    public abstract String getActionLink();
}

