/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests.ext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.server.core.IProjectProperties;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.tests.OrderedTestSuite;

public abstract class AbstractServerTestCase
extends TestCase {
    protected static IProject project;
    protected static IProjectProperties props;
    protected static IServer server;
    protected static IServerAttributes serverAttr;
    protected static IServerWorkingCopy serverWC;
    private static final PropertyChangeListener pcl;
    private static final IServerListener sl;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
            }
        };
        sl = new IServerListener(){

            public void serverChanged(ServerEvent event) {
            }
        };
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.tests.ext.AbstractServerTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz, "AbstractServerTestCase");
    }

    protected IServer getServer() throws Exception {
        if (server == null) {
            server = this.createServer();
            IServerWorkingCopy wc = server.createWorkingCopy();
            wc.saveAll(false, null);
        }
        return server;
    }

    public abstract IServer createServer() throws Exception;

    public abstract void deleteServer(IServer var1) throws Exception;

    public void test0000GetProperties() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        if (project != null && !project.exists()) {
            project.create(null);
            project.open(null);
        }
        props = ServerCore.getProjectProperties((IProject)project);
    }

    public void test0004End() throws Exception {
        project.delete(true, true, null);
    }

    public void test0005Delegate() throws Exception {
        IServer iServer = this.getServer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iServer.getAdapter((Class)clazz);
    }

    public void test0005bDelegate() throws Exception {
        IServer iServer = this.getServer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iServer.loadAdapter((Class)clazz, null);
    }

    public void test0005cDelegate() throws Exception {
        serverAttr = server;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serverAttr.getAdapter((Class)clazz);
    }

    public void test0005dDelegate() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serverAttr.loadAdapter((Class)clazz, null);
    }

    public void test0006Delegate() throws Exception {
        IServer iServer = this.getServer();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iServer.getAdapter((Class)clazz);
    }

    public void test0007Publish() throws Exception {
        this.getServer().publish(2, null);
    }

    public void test0008CanRun() throws Exception {
        AbstractServerTestCase.assertTrue((boolean)this.getServer().canStart("run").isOK());
    }

    public void test0009Run() throws Exception {
        this.getServer().synchronousStart("run", null);
    }

    public void test0010CanStop() throws Exception {
        AbstractServerTestCase.assertTrue((boolean)this.getServer().canStop().isOK());
    }

    public void test0011Stop() throws Exception {
        this.getServer().synchronousStop(false);
    }

    public void test0012CanDebug() throws Exception {
        AbstractServerTestCase.assertTrue((boolean)this.getServer().canStart("debug").isOK());
    }

    public void test0013Debug() throws Exception {
        server.synchronousStart("debug", null);
    }

    public void test0014CanStop() {
        AbstractServerTestCase.assertTrue((boolean)server.canStop().isOK());
    }

    public void test0015Stop() {
        server.synchronousStop(false);
    }

    public void test0016GetServerPorts() {
        ServerPort[] ports = server.getServerPorts(null);
        if (ports != null) {
            int size = ports.length;
            int i = 0;
            while (i < size) {
                ports[i].getId();
                ports[i].getContentTypes();
                ports[i].getName();
                ports[i].getPort();
                ports[i].getProtocol();
                ports[i].isAdvanced();
                ports[i].toString();
                ports[i].equals(null);
                ports[i].hashCode();
                ++i;
            }
        }
    }

    public void test0017GetServerState() {
        server.getServerState();
    }

    public void test0018GetServerPublishState() {
        server.getServerPublishState();
    }

    public void test0019GetServerRestartState() {
        server.getServerRestartState();
    }

    public void test0020GetModuleState() {
        try {
            server.getModuleState(null);
        }
        catch (Exception exception) {}
    }

    public void test0021GetModulePublishState() {
        try {
            server.getModulePublishState(null);
        }
        catch (Exception exception) {}
    }

    public void test0022GetModuleRestartState() {
        try {
            server.getModuleRestartState(null);
        }
        catch (Exception exception) {}
    }

    public void test0023GetMode() {
        server.getMode();
    }

    public void test0024CanPublish() {
        server.canPublish();
    }

    public void test0025CanRestart() {
        server.canRestart("run");
    }

    public void test0026CanControlModule() {
        try {
            server.canControlModule(null, null);
        }
        catch (Exception exception) {}
    }

    public void test0027AddServerListener() {
        server.addServerListener(sl);
    }

    public void test0028AddServerListener() {
        server.addServerListener(sl, 0);
    }

    public void test0029RemoveServerListener() {
        server.removeServerListener(sl);
    }

    public void test0030GetServerAttributes() {
        serverAttr = server;
    }

    public void test0031GetName() {
        serverAttr.getName();
    }

    public void test0032GetId() {
        serverAttr.getId();
    }

    public void test0033IsReadOnly() {
        serverAttr.isReadOnly();
    }

    public void test0034IsWorkingCopy() {
        serverAttr.isWorkingCopy();
    }

    public void test0035GetHost() {
        serverAttr.getHost();
    }

    public void test0036GetRuntime() {
        serverAttr.getRuntime();
    }

    public void test0037GetServerType() {
        serverAttr.getServerType();
    }

    public void test0038GetServerConfiguration() {
        serverAttr.getServerConfiguration();
    }

    public void test0039CreateWorkingCopy() {
        serverAttr.createWorkingCopy();
    }

    public void test0040GetModules() {
        serverAttr.getModules();
    }

    public void test0041CanModifyModules() {
        try {
            serverAttr.canModifyModules(null, null, null);
        }
        catch (Exception exception) {}
    }

    public void test0042GetChildModules() {
        try {
            serverAttr.getChildModules(null, null);
        }
        catch (Exception exception) {}
    }

    public void test0043GetRootModules() {
        try {
            serverAttr.getRootModules(null, null);
        }
        catch (Exception exception) {}
    }

    public void test0044GetServerPorts() {
        serverAttr.getServerPorts(null);
    }

    public void test0045Delete() {
        try {
            IServerWorkingCopy sa = serverAttr.createWorkingCopy();
            sa.delete();
        }
        catch (Exception exception) {}
    }

    public void test0046CreateWorkingCopy() {
        serverWC = server.createWorkingCopy();
    }

    public void test0047IsDirty() {
        AbstractServerTestCase.assertFalse((boolean)serverWC.isDirty());
    }

    public void test0048SetName() {
        serverWC.setName("test");
    }

    public void test0049SetHost() {
        serverWC.setHost("www.eclipse.org");
    }

    public void test0050SetReadOnly() {
        serverWC.setReadOnly(true);
    }

    public void test0051IsDirty() {
        AbstractServerTestCase.assertTrue((boolean)serverWC.isDirty());
    }

    public void test0052AddPropertyChangeListener() {
        serverWC.addPropertyChangeListener(pcl);
    }

    public void test0053RemovePropertyChangeListener() {
        serverWC.removePropertyChangeListener(pcl);
    }

    public void test0054GetOriginal() {
        serverWC.getOriginal();
    }

    public void test0055SetServerConfiguration() {
        serverWC.setServerConfiguration(null);
    }

    public void test0056ModifyModules() {
        try {
            serverWC.modifyModules(null, null, null);
        }
        catch (Exception exception) {}
    }

    public void test0057Clear() {
        serverAttr = null;
        serverWC = null;
    }

    public void test1001Delete() throws Exception {
        this.deleteServer(this.getServer());
        server = null;
    }
}

