/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.document;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jface.text.IDocument;

public class DocumentReader
extends Reader {
    private IDocument fDocument = null;
    private int mark = 0;
    private int position = 0;

    public DocumentReader() {
    }

    public DocumentReader(IDocument document) {
        this(document, 0);
    }

    public DocumentReader(IDocument document, int initialPosition) {
        this.fDocument = document;
        this.position = initialPosition;
    }

    public void close() throws IOException {
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void mark(int readAheadLimit) throws IOException {
        this.mark = this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        char[] readChars = null;
        try {
            if (this.position >= this.fDocument.getLength()) {
                return -1;
            }
            readChars = this.position + len > this.fDocument.getLength() ? this.fDocument.get(this.position, this.fDocument.getLength() - this.position).toCharArray() : this.fDocument.get(this.position, len).toCharArray();
            System.arraycopy(readChars, 0, cbuf, off, readChars.length);
            this.position += readChars.length;
            return readChars.length;
        }
        catch (Exception e) {
            throw new IOException("Exception while reading from IDocument: " + e);
        }
    }

    public void reset() throws IOException {
        this.position = this.mark;
    }

    public void reset(IDocument document, int initialPosition) {
        this.fDocument = document;
        this.position = initialPosition;
    }

    public void reset(int pos) throws IOException {
        this.position = pos;
    }

    public long skip(long n) throws IOException {
        long skipped = n;
        if ((long)this.position + n > (long)this.fDocument.getLength()) {
            skipped = this.fDocument.getLength() - this.position;
            this.position = this.fDocument.getLength();
        } else {
            this.position = (int)((long)this.position + n);
        }
        return skipped;
    }
}

