/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.componentcore.tests.TestWorkspace;

public class IVirtualFolderAPITest
extends TestCase {
    public static final IProject TEST_PROJECT = ResourcesPlugin.getWorkspace().getRoot().getProject("TestVirtualAPI");
    public static final String TEST_FOLDER_NAME = "WEB-INF";
    public static final Path WEBINF_FOLDER_REAL_PATH = new Path("/WebModule1/WebContent/WEB-INF");
    public static final Path WEBINF_FOLDER_RUNTIME_PATH = new Path("/WEB-INF");
    public static final Path TESTDATA_FOLDER_REAL_PATH = new Path("WebModule1/testdata");
    public static final Path TESTDATA_FOLDER_RUNTIME_PATH = new Path("/");
    private static final IPath DELETEME_PATH = new Path("/deleteme");
    private IVirtualComponent component;
    private IVirtualFolder webInfFolder;
    private IFolder realWebInfFolder;
    private IVirtualFolder deletemeVirtualFolder;
    private IFolder deletemeFolder;
    private IVirtualFolder testdataFolder;
    private IFolder realTestdataFolder;

    public IVirtualFolderAPITest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestWorkspace.init();
        this.realWebInfFolder = TEST_PROJECT.getFolder((IPath)WEBINF_FOLDER_REAL_PATH);
        this.component = ComponentCore.createComponent((IProject)TEST_PROJECT, (String)"WebModule1");
        IVirtualFolder rootFolder = this.component.getRootFolder();
        this.webInfFolder = rootFolder.getFolder((IPath)WEBINF_FOLDER_RUNTIME_PATH);
        this.testdataFolder = rootFolder.getFolder((IPath)TESTDATA_FOLDER_RUNTIME_PATH);
        this.realTestdataFolder = TEST_PROJECT.getFolder((IPath)TESTDATA_FOLDER_REAL_PATH);
        this.deletemeVirtualFolder = rootFolder.getFolder(DELETEME_PATH);
        this.deletemeVirtualFolder.create(256, null);
        this.deletemeFolder = this.deletemeVirtualFolder.getUnderlyingFolder();
    }

    public void testDelete() throws CoreException {
        IVirtualFolderAPITest.assertEquals((boolean)this.deletemeVirtualFolder.exists(), (boolean)true);
        this.deletemeVirtualFolder.delete(256, null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.deletemeFolder.exists()) {
            this.deletemeFolder.delete(256, null);
        }
    }

    public void testGetFileExtension() {
        IVirtualFolderAPITest.assertTrue((String)"The /WEB-INF folder should have no file extension.", (this.webInfFolder.getFileExtension() == null ? 1 : 0) != 0);
    }

    public void testGetUnderlyingFolders() {
        IFolder[] deletemeFolder = this.deletemeVirtualFolder.getUnderlyingFolders();
        IVirtualFolderAPITest.assertEquals((deletemeFolder.length == 1 ? 1 : 0) != 0, (boolean)true);
    }

    public void testGetUnderlyingResources() {
        IResource[] deletemeFolder = this.deletemeVirtualFolder.getUnderlyingResources();
        IVirtualFolderAPITest.assertEquals((deletemeFolder.length == 1 ? 1 : 0) != 0, (boolean)true);
    }

    public void testGetUnderlyingFolder() {
        IFolder deletemeFolder = this.deletemeVirtualFolder.getUnderlyingFolder();
        IVirtualFolderAPITest.assertNotNull((Object)deletemeFolder);
    }

    public void testGetUnderlyingResource() {
        IResource deletemeFolder = this.deletemeVirtualFolder.getUnderlyingResource();
        IVirtualFolderAPITest.assertNotNull((Object)deletemeFolder);
    }

    public void testGetWorkspaceRelativePath() {
        IPath realPath = this.realWebInfFolder.getFullPath();
        IPath virtualPath = this.webInfFolder.getWorkspaceRelativePath();
        IVirtualFolderAPITest.assertEquals((String)"The workspace relative path of the virtual resource must match the real resource", (Object)realPath, (Object)virtualPath);
    }

    public void testGetComponent() {
        IVirtualFolderAPITest.assertNotNull((Object)this.webInfFolder.getComponent());
    }

    public void testGetProjectRelativePath() {
        IPath realPath = this.realWebInfFolder.getProjectRelativePath();
        IPath virtualPath = this.webInfFolder.getProjectRelativePath();
        IVirtualFolderAPITest.assertEquals((String)"The project relative path of the virtual resource must match the real resource", (Object)realPath, (Object)virtualPath);
    }

    public void testGetRuntimePath() {
        IPath virtualPath = this.webInfFolder.getRuntimePath();
        IVirtualFolderAPITest.assertEquals((String)"The runtime path of the virtual resource must match the real resource", (Object)WEBINF_FOLDER_RUNTIME_PATH, (Object)virtualPath);
    }

    public void testGetName() {
        IVirtualFolderAPITest.assertEquals((String)"The name of the virtual resource must match the expected name.", (String)TEST_FOLDER_NAME, (String)this.webInfFolder.getName());
    }

    public void testGetParent() {
        IVirtualFolderAPITest.assertEquals((String)"The parent of the virtual resource must match the components root folder.", (Object)this.component.getRootFolder(), (Object)this.webInfFolder.getParent());
    }

    public void testEquals() {
        IVirtualContainer resource = this.webInfFolder.getParent();
        boolean bRetValue = resource.equals((Object)this.component.getRootFolder());
        IVirtualFolderAPITest.assertTrue((boolean)bRetValue);
    }

    public void testGetProject() {
        IVirtualFolderAPITest.assertEquals((String)"The project of the virtual resource must match the test project.", (Object)TEST_PROJECT, (Object)this.webInfFolder.getProject());
    }

    public void testGetType() {
        IVirtualFolderAPITest.assertEquals((String)"The type of the virtual resource must match the type of the test project.", (int)32, (int)this.webInfFolder.getType());
    }
}

