/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.FlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IFlexibleProject;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.componentcore.virtualpath.tests.TestWorkspace;

public class IFlexibleProjectAPITest
extends TestCase {
    private IFlexibleProject flexibleProject;

    public IFlexibleProjectAPITest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestWorkspace.init();
        this.flexibleProject = ComponentCore.createFlexibleProject((IProject)TestWorkspace.getTargetProject());
    }

    public void testFlexibleProjectIProject() {
        new FlexibleProject(TestWorkspace.getTargetProject());
    }

    public void testGetComponents() {
        IVirtualComponent[] components = this.flexibleProject.getComponents();
        IFlexibleProjectAPITest.assertEquals((String)"Verify the number of modules defined in the test project.", (int)TestWorkspace.MODULE_NAMES.length, (int)components.length);
        boolean found = false;
        int componentIndex = 0;
        while (componentIndex < components.length) {
            found = false;
            int moduleNamesIndex = 0;
            while (moduleNamesIndex < TestWorkspace.MODULE_NAMES.length) {
                if (TestWorkspace.MODULE_NAMES[moduleNamesIndex].equals(components[componentIndex].getName())) {
                    found = true;
                    break;
                }
                ++moduleNamesIndex;
            }
            IFlexibleProjectAPITest.assertTrue((String)("A component with the following name must be found in the project: " + components[componentIndex].getName()), (boolean)found);
            ++componentIndex;
        }
    }

    public void testGetComponent() {
        IVirtualComponent component = this.flexibleProject.getComponent("WebModule1");
        IFlexibleProjectAPITest.assertEquals((String)"The component must match the expected.", (String)"WebModule1", (String)component.getName());
    }

    public void testGetProject() {
        IFlexibleProjectAPITest.assertEquals((String)"The project associated with the flexible project must match the expected.", (Object)TestWorkspace.getTargetProject(), (Object)this.flexibleProject.getProject());
    }
}

