/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel.tests;

import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.enablement.DataModelEnablementFactory;
import org.eclipse.wst.common.frameworks.internal.operations.ProjectCreationDataModelProvider;

public class DataModelEnablementTest
extends TestCase {
    public void testValidExtensionIDAndProviderType() {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject("temp");
        if (proj == null) {
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new ProjectCreationDataModelProvider());
            model.setProperty("IProjectCreationProperties.PROJECT_NAME", (Object)"temp");
            IDataModelOperation op = model.getDefaultOperation();
            try {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            proj = ResourcesPlugin.getWorkspace().getRoot().getProject("temp");
        }
        IDataModel dataModel = DataModelEnablementFactory.createDataModel((String)"testProviderBase", (IProject)proj);
        DataModelEnablementTest.assertTrue((boolean)dataModel.isProperty("ITestDataModel.FOO"));
    }

    public void testValidExtensionIDImplementorForProviderType() {
        IDataModel dataModel;
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject("temp");
        if (proj == null) {
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new ProjectCreationDataModelProvider());
            model.setProperty("IProjectCreationProperties.PROJECT_NAME", (Object)"temp");
            IDataModelOperation op = model.getDefaultOperation();
            try {
                op.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            proj = ResourcesPlugin.getWorkspace().getRoot().getProject("temp");
        }
        DataModelEnablementTest.assertTrue(((dataModel = DataModelEnablementFactory.createDataModel((String)"testProviderBogus", (IProject)proj)) == null ? 1 : 0) != 0);
    }
}

