/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class TestAbstractDMProvider
extends TestCase {
    private static final String INTEGER = "INTEGER";
    private static final String BOOLEAN = "BOOLEAN";
    private static final String STRING = "STRING";
    private static final String OBJECT = "OBJECT";
    IDataModelProvider idmp = null;
    AbstractDataModelProvider dmp = null;
    IDataModel dm = null;
    IDataModelOperation idmo = null;
    AbstractDataModelOperation dmo = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.dmp = new DMProvider();
        this.idmp = this.dmp;
        this.dm = DataModelFactory.createDataModel((IDataModelProvider)this.dmp);
    }

    public void testAbstractDataModelProvider() {
        this.dmp.setDataModel(this.dm);
        TestAbstractDMProvider.assertTrue((this.dm == this.dmp.getDataModel() ? 1 : 0) != 0);
        TestAbstractDMProvider.assertNotNull((Object)this.dmp.getPropertyNames());
        this.dmp.init();
        TestAbstractDMProvider.assertNull((Object)this.dmp.getDefaultProperty(INTEGER));
        TestAbstractDMProvider.assertTrue((boolean)this.dmp.isPropertyEnabled(INTEGER));
        TestAbstractDMProvider.assertNull((Object)this.dmp.validate(INTEGER));
        TestAbstractDMProvider.assertTrue((boolean)this.dmp.propertySet(INTEGER, (Object)new Integer(1)));
        TestAbstractDMProvider.assertNull((Object)this.dmp.getPropertyDescriptor(INTEGER));
        TestAbstractDMProvider.assertNull((Object)this.dmp.getValidPropertyDescriptors(INTEGER));
        TestAbstractDMProvider.assertNull((Object)this.dmp.getExtendedContext());
        TestAbstractDMProvider.assertNull((Object)this.dmp.getDefaultOperation());
        TestAbstractDMProvider.assertTrue((boolean)this.dmp.getID().equals(this.dmp.getClass().getName()));
        ((DMProvider)this.dmp).protectedTest();
        this.dmp.dispose();
    }

    public void testIDataModelProvider() {
        this.idmp.setDataModel(this.dm);
        TestAbstractDMProvider.assertTrue((this.dm == this.idmp.getDataModel() ? 1 : 0) != 0);
        TestAbstractDMProvider.assertNotNull((Object)this.idmp.getPropertyNames());
        this.idmp.init();
        TestAbstractDMProvider.assertNull((Object)this.idmp.getDefaultProperty(INTEGER));
        TestAbstractDMProvider.assertTrue((boolean)this.idmp.isPropertyEnabled(INTEGER));
        TestAbstractDMProvider.assertNull((Object)this.idmp.validate(INTEGER));
        TestAbstractDMProvider.assertTrue((boolean)this.idmp.propertySet(INTEGER, (Object)new Integer(1)));
        TestAbstractDMProvider.assertNull((Object)this.idmp.getPropertyDescriptor(INTEGER));
        TestAbstractDMProvider.assertNull((Object)this.idmp.getValidPropertyDescriptors(INTEGER));
        TestAbstractDMProvider.assertNull((Object)this.idmp.getExtendedContext());
        TestAbstractDMProvider.assertNull((Object)this.idmp.getDefaultOperation());
        TestAbstractDMProvider.assertTrue((boolean)this.idmp.getID().equals(this.idmp.getClass().getName()));
        this.idmp.dispose();
    }

    public void testAbstractDataModelOperation() {
        this.dmo = new DMOp();
        this.dmo = new DMOp(this.dm);
        this.idmo = this.dmo;
        this.dmo.setID("foo");
        TestAbstractDMProvider.assertTrue((boolean)this.dmo.getID().equals("foo"));
        this.dmo.setDataModel(this.dm);
        TestAbstractDMProvider.assertTrue((this.dm == this.dmo.getDataModel() ? 1 : 0) != 0);
    }

    public void testIDataModelOperation() {
        this.dmo = new DMOp();
        this.idmo = this.dmo;
        this.idmo.setID("foo");
        TestAbstractDMProvider.assertTrue((boolean)this.idmo.getID().equals("foo"));
        this.idmo.setDataModel(this.dm);
        TestAbstractDMProvider.assertTrue((this.dm == this.idmo.getDataModel() ? 1 : 0) != 0);
    }

    private class DMOp
    extends AbstractDataModelOperation {
        public DMOp() {
        }

        public DMOp(IDataModel model) {
            super(model);
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return null;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return null;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return null;
        }

        public void setID(String id) {
            super.setID(id);
        }

        public String getID() {
            return super.getID();
        }

        public void setDataModel(IDataModel model) {
            super.setDataModel(model);
        }

        public IDataModel getDataModel() {
            return super.getDataModel();
        }
    }

    private class DMProvider
    extends AbstractDataModelProvider {
        DMProvider() {
        }

        public String[] getPropertyNames() {
            return DMProvider.combineProperties((String[])new String[]{TestAbstractDMProvider.INTEGER, TestAbstractDMProvider.BOOLEAN}, (String[])new String[]{TestAbstractDMProvider.STRING, TestAbstractDMProvider.OBJECT});
        }

        public void init() {
            super.init();
        }

        public Object getDefaultProperty(String propertyName) {
            return super.getDefaultProperty(propertyName);
        }

        public boolean isPropertyEnabled(String propertyName) {
            return super.isPropertyEnabled(propertyName);
        }

        public IStatus validate(String name) {
            return super.validate(name);
        }

        public boolean propertySet(String propertyName, Object propertyValue) {
            return super.propertySet(propertyName, propertyValue);
        }

        public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
            return super.getPropertyDescriptor(propertyName);
        }

        public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
            return super.getValidPropertyDescriptors(propertyName);
        }

        public List getExtendedContext() {
            return super.getExtendedContext();
        }

        public IDataModelOperation getDefaultOperation() {
            return super.getDefaultOperation();
        }

        public String getID() {
            return super.getID();
        }

        public void dispose() {
            super.dispose();
        }

        public void protectedTest() {
            super.getProperty(TestAbstractDMProvider.INTEGER);
            super.setProperty(TestAbstractDMProvider.INTEGER, (Object)new Integer(1));
            super.getBooleanProperty(TestAbstractDMProvider.BOOLEAN);
            super.setBooleanProperty(TestAbstractDMProvider.BOOLEAN, true);
            super.getIntProperty(TestAbstractDMProvider.INTEGER);
            super.setIntProperty(TestAbstractDMProvider.INTEGER, 1);
            super.getStringProperty(TestAbstractDMProvider.STRING);
            super.isPropertySet(TestAbstractDMProvider.INTEGER);
        }
    }
}

