/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.tests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;
import org.eclipse.wst.common.tests.CommonTestsPlugin;
import org.eclipse.wst.common.tests.DataModelVerifier;
import org.eclipse.wst.common.tests.DataModelVerifierList;

public class DataModelVerifierFactory
extends RegistryReader {
    static final String DATA_MODEL_VERIFIER_LIST_EXT = "dataModelVerifierList";
    static final String LIST_CLASS = "listClass";
    private Map dataModelVerifiersMap = null;
    private static DataModelVerifierFactory instance = null;
    private DataModelVerifier defaultDataModelVerifier = new DataModelVerifier();

    public DataModelVerifierFactory() {
        super(CommonTestsPlugin.PLUGIN_ID, "DataModelVerifier");
    }

    public static DataModelVerifierFactory getInstance() {
        if (instance == null) {
            instance = new DataModelVerifierFactory();
            instance.readRegistry();
        }
        return instance;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(DATA_MODEL_VERIFIER_LIST_EXT)) {
            return false;
        }
        try {
            DataModelVerifierList list = (DataModelVerifierList)element.createExecutableExtension(LIST_CLASS);
            this.addToDataModelVerifiersMap(list.getDataModelVerifiers());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    public DataModelVerifier createVerifier(WTPOperationDataModel model) {
        DataModelVerifier verifier = this.getDefaultDataModelVerifier();
        String verifierClassName = null;
        if (model != null && (verifierClassName = (String)this.getDataModelVerifiersMap().get(model.getClass().getName())) != null) {
            try {
                Class<?> verifierClass = Class.forName(verifierClassName);
                verifier = (DataModelVerifier)verifierClass.newInstance();
            }
            catch (Exception exception) {
                verifier = this.getDefaultDataModelVerifier();
            }
        }
        return verifier;
    }

    protected void addToDataModelVerifiersMap(Map dataModelVerifiers) {
        if (this.dataModelVerifiersMap == null) {
            this.dataModelVerifiersMap = this.initDataModelVerifiersMap();
        }
        this.dataModelVerifiersMap.putAll(dataModelVerifiers);
    }

    public Map getDataModelVerifiersMap() {
        if (this.dataModelVerifiersMap == null) {
            this.dataModelVerifiersMap = this.initDataModelVerifiersMap();
        }
        return this.dataModelVerifiersMap;
    }

    protected Map initDataModelVerifiersMap() {
        return new HashMap();
    }

    protected DataModelVerifier getDefaultDataModelVerifier() {
        return this.defaultDataModelVerifier;
    }
}

