/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistry;
import org.eclipse.wst.sse.ui.internal.provisional.registry.AdapterFactoryRegistryImpl;
import org.eclipse.wst.sse.ui.internal.provisional.registry.embedded.EmbeddedAdapterFactoryRegistryImpl;
import org.eclipse.wst.xml.ui.internal.JobStatusLineHelper;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogFileType;
import org.eclipse.wst.xml.ui.internal.preferences.XMLUIPreferenceNames;
import org.eclipse.wst.xml.ui.internal.templates.TemplateContextTypeIdsXML;
import org.osgi.framework.BundleContext;

public class XMLUIPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.wst.xml.ui";
    protected static XMLUIPlugin instance = null;
    protected static HashMap catalogFileTypeMap = new HashMap();
    private ContextTypeRegistry fContextTypeRegistry;
    private TemplateStore fTemplateStore;

    public static XMLUIPlugin getDefault() {
        return instance;
    }

    public static synchronized XMLUIPlugin getInstance() {
        return instance;
    }

    public XMLUIPlugin() {
        instance = this;
        JobStatusLineHelper.init();
    }

    public AdapterFactoryRegistry getAdapterFactoryRegistry() {
        return AdapterFactoryRegistryImpl.getInstance();
    }

    public AdapterFactoryRegistry getEmbeddedAdapterFactoryRegistry() {
        return EmbeddedAdapterFactoryRegistryImpl.getInstance();
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), this.getPreferenceStore(), XMLUIPreferenceNames.TEMPLATES_KEY);
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
        return this.fTemplateStore;
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType(TemplateContextTypeIdsXML.ALL);
            registry.addContextType(TemplateContextTypeIdsXML.NEW);
            registry.addContextType(TemplateContextTypeIdsXML.TAG);
            registry.addContextType(TemplateContextTypeIdsXML.ATTRIBUTE);
            registry.addContextType(TemplateContextTypeIdsXML.ATTRIBUTE_VALUE);
            this.fContextTypeRegistry = registry;
        }
        return this.fContextTypeRegistry;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        new CatalogFileTypeRegistryReader(catalogFileTypeMap).readRegistry();
    }

    public static Collection getXMLCatalogFileTypes() {
        return catalogFileTypeMap.values();
    }

    public Image getImage(String imageName) {
        return this.getWorkbench().getSharedImages().getImage(imageName);
    }

    class CatalogFileTypeRegistryReader
    extends BaseRegistryReader {
        protected static final String EXTENSION_POINT_ID = "catalogFileType";
        protected static final String TAG_NAME = "fileType";
        protected static final String ATT_ID = "id";
        protected static final String ATT_EXTENSIONS = "extensions";
        protected static final String ATT_DESCRIPTION = "description";
        protected static final String ATT_ICON = "icon";
        protected HashMap hashMap;

        public CatalogFileTypeRegistryReader(HashMap hashMap) {
            this.hashMap = hashMap;
        }

        public void readRegistry() {
            this.readRegistry(EXTENSION_POINT_ID);
        }

        protected void readElement(IConfigurationElement element) {
            String id;
            if (element.getName().equals(TAG_NAME) && (id = element.getAttribute(ATT_ID)) != null) {
                XMLCatalogFileType fileType = (XMLCatalogFileType)this.hashMap.get(id);
                if (fileType == null) {
                    fileType = new XMLCatalogFileType();
                    this.hashMap.put(id, fileType);
                }
                if (fileType.description == null) {
                    String description;
                    fileType.description = description = element.getAttribute(ATT_DESCRIPTION);
                }
                fileType.addExtensions(element.getAttribute(ATT_EXTENSIONS));
            }
        }
    }

    class BaseRegistryReader {
        BaseRegistryReader() {
        }

        public void readRegistry(String extensionPointId) {
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint point = pluginRegistry.getExtensionPoint(XMLUIPlugin.ID, extensionPointId);
            if (point != null) {
                IConfigurationElement[] elements = point.getConfigurationElements();
                int i = 0;
                while (i < elements.length) {
                    this.readElement(elements[i]);
                    ++i;
                }
            }
        }

        protected void readElement(IConfigurationElement element) {
        }
    }
}

