/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.ViewerSelectionManager;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;
import org.eclipse.wst.xml.ui.internal.dnd.XMLDragAndDropManager;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeContentProvider;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTreeExtension;

public class XMLTableTreeViewer
extends TreeViewer
implements IDesignViewer {
    protected CellEditor cellEditor;
    int count = 0;
    protected IModelStateListener fInternalModelStateListener = new InternalModelStateListener();
    protected IStructuredModel fModel = null;
    protected INodeSelectionListener fNodeSelectionListener;
    protected ViewerSelectionManager fViewerSelectionManager;
    protected boolean ignoreRefresh;
    protected DelayedRefreshTimer timer;
    protected XMLTreeExtension treeExtension = new XMLTreeExtension(this.getTree());

    public XMLTableTreeViewer(Composite parent) {
        super(parent, 66306);
        XMLTableTreeContentProvider provider = new XMLTableTreeContentProvider();
        provider.addViewer((Viewer)this);
        this.setContentProvider((IContentProvider)provider);
        this.setLabelProvider((IBaseLabelProvider)provider);
        this.createContextMenu();
        XMLDragAndDropManager.addDragAndDropSupport(this);
        this.timer = new DelayedRefreshTimer(this);
    }

    protected void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)new NodeActionMenuListener());
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    protected void doRefresh(Object o, boolean fromDelayed) {
        this.treeExtension.resetCachedData();
        super.refresh(o);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        if (!this.getTree().isDisposed() && !this.getTree().isFocusControl()) {
            this.removeSelectionChangedListener((ISelectionChangedListener)this.fViewerSelectionManager);
            super.fireSelectionChanged(event);
            this.addSelectionChangedListener((ISelectionChangedListener)this.fViewerSelectionManager);
        } else {
            super.fireSelectionChanged(event);
        }
    }

    public INodeSelectionListener getNodeSelectionListener() {
        if (this.fNodeSelectionListener == null) {
            this.fNodeSelectionListener = new DelayingNodeSelectionListener();
        }
        return this.fNodeSelectionListener;
    }

    public String getTitle() {
        return XMLEditorMessages.XMLTableTreeViewer_0;
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.treeExtension.dispose();
        this.setModel(null);
        this.setViewerSelectionManager(null);
    }

    public void refresh() {
        if (!this.ignoreRefresh && !this.getControl().isDisposed()) {
            if (Display.getCurrent() != null) {
                this.refreshTree();
            } else {
                final Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (display != null && !display.isDisposed()) {
                            XMLTableTreeViewer.this.refreshTree();
                        }
                    }
                });
            }
        }
    }

    void refreshTree() {
        this.treeExtension.resetCachedData();
        super.refresh();
        this.getTree().redraw(0, 0, this.getTree().getBounds().width, this.getTree().getBounds().height, false);
        this.getTree().update();
    }

    public void refresh(Object o) {
        if (!this.ignoreRefresh && !this.getControl().isDisposed() && this.timer != null) {
            if (Display.getCurrent() != null) {
                this.refreshTree(o);
            } else {
                final Object object = o;
                final Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (display != null && !display.isDisposed()) {
                            XMLTableTreeViewer.this.refreshTree(object);
                        }
                    }
                });
            }
        }
    }

    void refreshTree(Object o) {
        if (this.getTree().isVisible()) {
            this.doRefresh(o, false);
        } else {
            this.timer.refresh(o);
        }
    }

    public void setModel(IStructuredModel model) {
        if (this.fModel != null) {
            this.fModel.removeModelStateListener(this.fInternalModelStateListener);
        }
        this.fModel = model;
        IDOMDocument domDoc = null;
        if (this.fModel != null && this.fModel instanceof IDOMModel) {
            model.addModelStateListener(this.fInternalModelStateListener);
            ModelQuery mq = ModelQueryUtil.getModelQuery((IStructuredModel)model);
            this.treeExtension.setModelQuery(mq);
            domDoc = ((IDOMModel)this.fModel).getDocument();
            this.setInput(domDoc);
        }
    }

    public void setViewerSelectionManager(ViewerSelectionManager viewerSelectionManager) {
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.removeNodeSelectionListener(this.getNodeSelectionListener());
            this.removeSelectionChangedListener((ISelectionChangedListener)this.fViewerSelectionManager);
        }
        this.fViewerSelectionManager = viewerSelectionManager;
        if (this.fViewerSelectionManager != null) {
            this.fViewerSelectionManager.addNodeSelectionListener(this.getNodeSelectionListener());
            this.addSelectionChangedListener((ISelectionChangedListener)this.fViewerSelectionManager);
        }
    }

    class DelayedRefreshTimer
    implements Runnable {
        private final int delta = 2000;
        protected Object objectPendingRefresh;
        protected ISelection pendingSelection;
        protected Object prevObject;
        protected XMLTableTreeViewer viewer;

        public DelayedRefreshTimer(XMLTableTreeViewer treeViewer) {
            this.viewer = treeViewer;
        }

        public boolean isRefreshPending() {
            return this.objectPendingRefresh != null;
        }

        public void refresh(Object object) {
            if (this.prevObject == object) {
                this.objectPendingRefresh = object;
                this.getDisplay().timerExec(2000, (Runnable)this);
            } else {
                if (this.objectPendingRefresh != null) {
                    this.viewer.doRefresh(this.objectPendingRefresh, false);
                    this.objectPendingRefresh = null;
                }
                this.viewer.doRefresh(object, false);
            }
            this.prevObject = object;
        }

        private Display getDisplay() {
            return PlatformUI.getWorkbench().getDisplay();
        }

        public void run() {
            if (this.objectPendingRefresh != null && !this.viewer.getTree().isDisposed()) {
                this.viewer.doRefresh(this.objectPendingRefresh, true);
                if (this.pendingSelection != null) {
                    this.viewer.setSelection(this.pendingSelection, true);
                    this.pendingSelection = null;
                }
                this.objectPendingRefresh = null;
                this.prevObject = null;
            }
        }

        public void setSelection(ISelection selection) {
            this.pendingSelection = selection;
        }
    }

    class DelayingNodeSelectionListener
    implements INodeSelectionListener {
        DelayingNodeSelectionListener() {
        }

        public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
            if (!event.getSource().equals(XMLTableTreeViewer.this)) {
                List selectedNodes = event.getSelectedNodes();
                StructuredSelection selection = new StructuredSelection(selectedNodes);
                if (selectedNodes.size() < 100) {
                    if (XMLTableTreeViewer.this.timer.isRefreshPending()) {
                        XMLTableTreeViewer.this.timer.setSelection((ISelection)selection);
                    } else {
                        XMLTableTreeViewer.this.setSelection((ISelection)selection, true);
                    }
                }
            }
        }
    }

    class InternalModelStateListener
    implements IModelStateListener {
        InternalModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
            XMLTableTreeViewer.this.ignoreRefresh = true;
        }

        public void modelChanged(IStructuredModel model) {
            XMLTableTreeViewer.this.ignoreRefresh = false;
            XMLTableTreeViewer.this.refresh();
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel originalmodel, IStructuredModel movedmodel) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }
    }

    class NodeActionMenuListener
    implements IMenuListener {
        NodeActionMenuListener() {
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            XMLNodeActionManager nodeActionManager = new XMLNodeActionManager(this, XMLTableTreeViewer.this.fModel, (Viewer)XMLTableTreeViewer.this){
                final /* synthetic */ NodeActionMenuListener this$1;
                {
                    this.this$1 = nodeActionMenuListener;
                }

                public void beginNodeAction(NodeAction action) {
                    super.beginNodeAction(action);
                }

                public void endNodeAction(NodeAction action) {
                    super.endNodeAction(action);
                }
            };
            nodeActionManager.fillContextMenu(menuManager, XMLTableTreeViewer.this.getSelection());
        }
    }
}

