/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.tests.internal;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.wst.ws.internal.ui.plugin.WSUIPlugin;
import org.eclipse.wst.ws.internal.ui.wsi.preferences.PersistentWSISSBPContext;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.ui.eclipse.WSDLValidator;
import org.eclipse.wst.wsdl.validation.tests.internal.WSDLValidatorTestsPlugin;

public class BaseTestCase
extends TestCase {
    protected String FILE_PROTOCOL = "file:///";
    protected String PLUGIN_ABSOLUTE_PATH;
    protected String SAMPLES_DIR = "testresources/samples/";
    protected String GENERATED_RESULTS_DIR = "testresources/generatedResults/";
    protected String IDEAL_RESULTS_DIR = "testresources/idealResults/";
    protected String LOG_FILE_LOCATION = "results.log";
    protected static final String PLUGIN_NAME = "org.eclipse.wst.wsdl.validation.tests";
    private WSDLValidator validator = WSDLValidator.getInstance();

    protected void setUp() {
        this.PLUGIN_ABSOLUTE_PATH = WSDLValidatorTestsPlugin.getInstallURL();
        WSUIPlugin wsui = WSUIPlugin.getInstance();
        PersistentWSISSBPContext wsicontext = wsui.getWSISSBPContext();
        wsicontext.updateWSICompliances("2");
        wsicontext = wsui.getWSIAPContext();
        wsicontext.updateWSICompliances("2");
    }

    public void runTest(String testfile, String loglocation, String idealloglocation) {
        IValidationReport valreport = this.validator.validate(testfile);
        try {
            this.createLog(loglocation, valreport);
            String generatedLog = this.getStringFromFile(loglocation);
            String idealLog = this.getStringFromFile(idealloglocation);
            BaseTestCase.assertEquals((String)idealLog, (String)generatedLog);
        }
        catch (Exception exception) {
            BaseTestCase.fail((String)"Could not compare log files");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getStringFromFile(String filename) throws Exception {
        if (filename.startsWith("file:")) {
            filename = filename.substring(6);
            while (filename.startsWith("\\") || filename.startsWith("/")) {
                filename = filename.substring(1);
            }
        }
        StringBuffer filestring = new StringBuffer();
        Reader reader = null;
        BufferedReader bufreader = null;
        try {
            try {
                File file = new File(filename);
                reader = new FileReader(file);
                bufreader = new BufferedReader(reader);
                while (bufreader.ready()) {
                    filestring.append(String.valueOf(bufreader.readLine()) + "\n");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Exception();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            bufreader.close();
            reader.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        bufreader.close();
        reader.close();
        return filestring.toString();
    }

    private String createLog(String filename, IValidationReport valreport) {
        if (filename.startsWith("file:")) {
            filename = filename.substring(6);
            while (filename.startsWith("\\") || filename.startsWith("/")) {
                filename = filename.substring(1);
            }
        }
        IValidationMessage[] valmessages = valreport.getValidationMessages();
        int nummessages = valmessages.length;
        StringBuffer errorsString = new StringBuffer();
        StringBuffer warningsString = new StringBuffer();
        int numerrors = 0;
        int numwarnings = 0;
        int i = 0;
        while (i < nummessages) {
            String message;
            IValidationMessage valmes = valmessages[i];
            if (valmes.getSeverity() == 1) {
                ++numwarnings;
                message = valmes.getMessage();
                message = message.replaceAll("'[^']*org.eclipse.wst.wsdl.validation.tests[^'/]*/", "'");
                message = message.replaceAll("[(][^(]*org.eclipse.wst.wsdl.validation.tests[^'/]*/", "[(]");
                warningsString.append(String.valueOf(message) + " [" + valmes.getLine() + ", " + valmes.getColumn() + "]\n");
                warningsString.append(this.createNestedMessageString(valmes.getNestedMessages()));
            } else {
                ++numerrors;
                message = valmes.getMessage();
                message = message.replaceAll("'[^']*org.eclipse.wst.wsdl.validation.tests[^'/]*/", "'");
                message = message.replaceAll("[(][^(]*org.eclipse.wst.wsdl.validation.tests[^'/]*/", "(");
                errorsString.append(String.valueOf(message) + " [" + valmes.getLine() + ", " + valmes.getColumn() + "]\n");
                errorsString.append(this.createNestedMessageString(valmes.getNestedMessages()));
            }
            ++i;
        }
        StringBuffer log = new StringBuffer();
        log.append("number of errors      : " + numerrors + "\n");
        log.append("number of warnings    : " + numwarnings + "\n\n");
        log.append("------------error list-------------------------------------------\n");
        if (numerrors == 0) {
            log.append("(none)\n");
        } else {
            log.append(errorsString.toString());
        }
        log.append("------------warning list-----------------------------------------\n");
        if (numwarnings == 0) {
            log.append("(none)\n");
        } else {
            log.append(warningsString.toString());
        }
        log.append("-----------------------------------------------------------------\n");
        DataOutputStream outStream = null;
        try {
            File logfile = new File(filename);
            File parent = logfile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (logfile.exists()) {
                logfile.delete();
            }
            logfile.createNewFile();
            outStream = new DataOutputStream(new FileOutputStream(filename, true));
            outStream.writeBytes(log.toString());
            outStream.close();
        }
        catch (IOException iOException) {
            log.delete(0, log.length());
        }
        return log.toString();
    }

    private String createNestedMessageString(List nestedMessages) {
        return this.createNestedMessageString(nestedMessages, 0);
    }

    private String createNestedMessageString(List nestedMessages, int depth) {
        if (nestedMessages != null && nestedMessages.size() > 0) {
            String messageString = "";
            Iterator nestedMesIter = nestedMessages.iterator();
            while (nestedMesIter.hasNext()) {
                IValidationMessage nesvalmes = (IValidationMessage)nestedMesIter.next();
                int i = 0;
                while (i < depth) {
                    messageString = String.valueOf(messageString) + " ";
                    ++i;
                }
                String message = nesvalmes.getMessage();
                message = message.replaceAll("'[^']*org.eclipse.wst.wsdl.validation.tests[^'/]*/", "'");
                message = message.replaceAll("[(][^(]*org.eclipse.wst.wsdl.validation.tests[^'/]*/", "[(]");
                messageString = String.valueOf(messageString) + "-> " + message + " [" + nesvalmes.getLine() + ", " + nesvalmes.getColumn() + "]\n";
                messageString = String.valueOf(messageString) + this.createNestedMessageString(nesvalmes.getNestedMessages(), depth + 1);
            }
            return messageString;
        }
        return "";
    }
}

