/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.modelquery.XMLCatalogIdResolver;

public class TestCatalogRetrivalAndModelCreation
extends TestCase {
    public void testKnownNotExist() throws MalformedURLException, IOException {
        String JUNK_STRING = "doesNotExistTest";
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolvePublic(JUNK_STRING, null);
        TestCatalogRetrivalAndModelCreation.assertNull((String)("expected no match for " + JUNK_STRING), (Object)resolved);
    }

    public void removedtestWAPFORUM() throws MalformedURLException, IOException {
        this.doTest("-//WAPFORUM//DTD WML 1.1//EN");
    }

    public void testXHTML10() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML 1.0 Strict//EN");
    }

    public void testXHTML10T() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML 1.0 Transitional//EN");
    }

    public void testXHTML10F() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML 1.0 Frameset//EN");
    }

    public void testXHTML10B() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML Basic 1.0//EN");
    }

    public void testXHTML11() throws MalformedURLException, IOException {
        this.doTest("-//W3C//DTD XHTML 1.1//EN");
    }

    public void testXHTML11_xmlresolver() throws MalformedURLException, IOException {
        String EXPECTED_PUBLICID = "-//W3C//DTD XHTML 1.1//EN";
        XMLCatalogIdResolver resolver = new XMLCatalogIdResolver(null, null);
        String resolvedXML_Id = resolver.resolve(null, EXPECTED_PUBLICID, null);
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolvedXL_Cat = xmlCatalog.resolvePublic(EXPECTED_PUBLICID, null);
        TestCatalogRetrivalAndModelCreation.assertEquals((String)resolvedXL_Cat, (String)resolvedXML_Id);
    }

    public void testCMXHTML11() throws MalformedURLException, IOException {
        this.doCMTest("-//W3C//DTD XHTML 1.1//EN");
    }

    public void removedtestXHTML10M() throws MalformedURLException, IOException {
        this.doTest("-//WAPFORUM//DTD XHTML Mobile 1.0//EN");
    }

    public void removedtestWAP13() throws MalformedURLException, IOException {
        this.doTest("-//WAPFORUM//DTD WML 1.3//EN");
    }

    public void test2001Schema() throws MalformedURLException, IOException {
        this.doURITest("http://www.w3.org/2001/XMLSchema");
    }

    public void testExternalDTD() throws MalformedURLException, IOException {
        this.doCM_directURITest("http://hibernate.sourceforge.net/hibernate-configuration-3.0.dtd");
    }

    public void test2001SchemaCMDirect() throws MalformedURLException, IOException {
        this.doCM_directURITest("http://www.w3.org/2001/XMLSchema.xsd");
    }

    public void test2001SchemaCMCatalog() throws MalformedURLException, IOException {
        this.doURI_CMTest("http://www.w3.org/2001/XMLSchema");
    }

    private void doTest(String EXPECTED_PUBLICID) throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolvePublic(EXPECTED_PUBLICID, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to find " + EXPECTED_PUBLICID), (Object)resolved);
    }

    private void doCMTest(String EXPECTED_PUBLICID) throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolvePublic(EXPECTED_PUBLICID, null);
        ContentModelManager contentModelManager = ContentModelManager.getInstance();
        CMDocument contentModel = contentModelManager.createCMDocument(resolved, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to create content model for " + EXPECTED_PUBLICID), (Object)contentModel);
    }

    private void doCM_directURITest(String EXPECTED_URI) throws MalformedURLException, IOException {
        ContentModelManager contentModelManager = ContentModelManager.getInstance();
        CMDocument contentModel = contentModelManager.createCMDocument(EXPECTED_URI, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to create content model for " + EXPECTED_URI), (Object)contentModel);
    }

    private void doURITest(String EXPECTED_URI) throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolveURI(EXPECTED_URI);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to find " + EXPECTED_URI), (Object)resolved);
    }

    private void doURI_CMTest(String EXPECTED_URI) throws MalformedURLException, IOException {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        String resolved = xmlCatalog.resolveURI(EXPECTED_URI);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to find " + EXPECTED_URI), (Object)resolved);
        ContentModelManager contentModelManager = ContentModelManager.getInstance();
        CMDocument contentModel = contentModelManager.createCMDocument(resolved, null);
        TestCatalogRetrivalAndModelCreation.assertNotNull((String)("expected to create content model for " + EXPECTED_URI), (Object)contentModel);
    }
}

