/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.document;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Position;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.xml.core.internal.modelhandler.ModelHandlerForXML;
import org.eclipse.wst.xml.core.internal.modelhandler.XMLModelLoader;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public class TestStructuredDocument
extends TestCase {
    private boolean isSetup = false;
    private XMLModelLoader fLoader = null;
    private final String fProjectName = "DOCUMENT-LOADER";
    private final String fZipFileName = "xml-document-loader-tests.zip";

    public TestStructuredDocument() {
        super("TestStructuredDocument");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.fLoader = new XMLModelLoader();
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "xml-document-loader-tests.zip", "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject("DOCUMENT-LOADER");
    }

    public IStructuredModel getUnmanagedModel() {
        IFile f = this.getFile();
        IStructuredModel model = null;
        try {
            model = this.fLoader.createModel();
            this.fLoader.load(f, model);
            ModelHandlerForXML xmlModelHandler = new ModelHandlerForXML();
            model.setModelHandler((IModelHandler)xmlModelHandler);
            model.setBaseLocation("DOCUMENT-LOADER/files/simple.xml");
            try {
                model.setId("DOCUMENT-LOADER/files/simple.xml");
            }
            catch (ResourceInUse resourceInUse) {}
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return model;
    }

    private IFile getFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("DOCUMENT-LOADER/files/simple.xml"));
    }

    public void testDocumentChangingListener() throws BadLocationException {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        TestListener listener = new TestListener();
        sDoc.addDocumentChangingListener((IStructuredDocumentListener)listener);
        String text = sDoc.get();
        sDoc.replace(0, text.length(), text);
        sDoc.removeDocumentChangingListener((IStructuredDocumentListener)listener);
    }

    public void testReadOnly() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        String text = sDoc.get();
        sDoc.clearReadOnly(0, text.length());
        TestStructuredDocument.assertFalse((boolean)sDoc.containsReadOnly(0, text.length()));
        sDoc.makeReadOnly(0, 10);
        TestStructuredDocument.assertTrue((boolean)sDoc.containsReadOnly(9, 1));
        TestStructuredDocument.assertTrue((boolean)sDoc.containsReadOnly(0, text.length()));
        sDoc.clearReadOnly(0, text.length());
        TestStructuredDocument.assertFalse((boolean)sDoc.containsReadOnly(0, text.length()));
    }

    public void testGetRegionAtCharacterOffset() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        IStructuredDocumentRegion r = sDoc.getRegionAtCharacterOffset(0);
        TestStructuredDocument.assertNotNull((String)"couldn't get region at offset: 0", (Object)r);
        r = sDoc.getRegionAtCharacterOffset(sDoc.getLength());
        TestStructuredDocument.assertNotNull((String)("couldn't get region at offset: " + sDoc.getLength()), (Object)r);
    }

    public void testGetRegionList() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        IStructuredDocumentRegionList regions = sDoc.getRegionList();
        TestStructuredDocument.assertNotNull((String)"couldn't get region list", (Object)regions);
        TestStructuredDocument.assertEquals((int)17, (int)regions.getLength());
    }

    public void testGetText() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        String text = sDoc.getText();
        String expectedText = "<?xml version=\"1.0\"?>\r\n<list>\r\n\t<item1 attr1=\"attr1\" attr2=\"attr2\" attr3=\"attr3\">\r\n\t\tone\r\n\t</item1>\r\n\t<item2 attr1=\"attr1\" attr2=\"attr2\" attr3=\"attr3\" >\r\n\t\ttwo\r\n\t</item2>\r\n\t<item3 attr1=\"attr1\" attr2=\"attr2\" attr3=\"attr3\">\r\n\t\tthree\r\n\t</item3>\r\n</list>";
        TestStructuredDocument.assertEquals((String)expectedText, (String)text);
    }

    public void testNewInstance() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        IStructuredDocument newDoc = sDoc.newInstance();
        TestStructuredDocument.assertNotSame((String)"document instances should be different", (Object)sDoc, (Object)newDoc);
    }

    public void testReplaceText() throws BadLocationException {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        sDoc.replace(0, sDoc.getLength(), "replaced");
        String text = sDoc.getText();
        TestStructuredDocument.assertEquals((String)"replaced", (String)text);
    }

    public void testOverrideReadOnlyReplaceText() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        sDoc.makeReadOnly(0, 1);
        sDoc.replaceText((Object)this, 0, sDoc.getLength(), "replaced");
        TestStructuredDocument.assertNotSame((String)"text should not have been replacable (read only)", (Object)"replaced", (Object)sDoc.getText());
        sDoc.replaceText((Object)this, 0, sDoc.getLength(), "replaced", true);
        TestStructuredDocument.assertEquals((String)"text should have been forced replaced", (String)"replaced", (String)sDoc.getText());
    }

    public void testSetText() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        sDoc.setText((Object)this, "set text");
        TestStructuredDocument.assertEquals((String)"set text failed", (String)"set text", (String)sDoc.getText());
    }

    public void testGetEncodingMemento() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        EncodingMemento memento = sDoc.getEncodingMemento();
        TestStructuredDocument.assertNotNull((String)"couldn't get encoding memento", (Object)memento);
    }

    public void testGetDetectedLineDelimiter() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        String delim = sDoc.getLineDelimiter();
        TestStructuredDocument.assertEquals((String)"wrong preferred line delmiter", (String)"\r\n", (String)delim);
    }

    public void testSetEncodingMemento() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        EncodingMemento memento = new EncodingMemento();
        sDoc.setEncodingMemento(memento);
        EncodingMemento gottenMemento = sDoc.getEncodingMemento();
        TestStructuredDocument.assertEquals((String)"mementos don't match", (Object)memento, (Object)gottenMemento);
    }

    public void setDetectedLineDelimiter() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        sDoc.setPreferredLineDelimiter("\n");
        String delim = sDoc.getPreferredLineDelimiter();
        TestStructuredDocument.assertEquals((String)"set line delimiter failed", (String)"\n", (String)delim);
        sDoc.setPreferredLineDelimiter("\r\n");
        delim = sDoc.getPreferredLineDelimiter();
        TestStructuredDocument.assertEquals((String)"set line delimiter failed", (String)"\r\n", (String)delim);
    }

    public void testStringMatches() {
    }

    public void testCreatePosition() throws BadPositionCategoryException, BadLocationException {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument sDoc = model.getStructuredDocument();
        Position p = new Position(0, 10);
        String[] categories = sDoc.getPositionCategories();
        int i = 0;
        while (i < categories.length) {
            sDoc.addPosition(categories[i], p);
            ++i;
        }
        int found = 0;
        int i2 = 0;
        while (i2 < categories.length) {
            Position[] positions = sDoc.getPositions(categories[i2]);
            int j = 0;
            while (j < positions.length) {
                if (positions[j] == p) {
                    ++found;
                }
                ++j;
            }
            ++i2;
        }
        TestStructuredDocument.assertEquals((String)"wrong number of positions", (int)categories.length, (int)found);
    }

    class TestListener
    implements IStructuredDocumentListener {
        boolean newModelCalled = false;
        boolean noChangeCalled = false;
        boolean nodesReplacedCalled = false;
        boolean regionChangedCalled = false;
        boolean regionsReplacedCalled = false;

        TestListener() {
        }

        public void newModel(NewDocumentEvent structuredDocumentEvent) {
            this.newModelCalled = true;
        }

        public void noChange(NoChangeEvent structuredDocumentEvent) {
            this.noChangeCalled = true;
        }

        public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
            this.nodesReplacedCalled = true;
        }

        public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
            this.regionChangedCalled = true;
        }

        public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
            this.regionsReplacedCalled = true;
        }
    }
}

