/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.dom;

import junit.framework.TestCase;
import org.eclipse.wst.xml.core.internal.provisional.NameValidator;

public class NameValidatorTests
extends TestCase {
    private int nTrials = 100;

    public NameValidatorTests(String name) {
        super(name);
    }

    private void doTest(int testNumber, String testString, Boolean expectedValidity) {
        boolean isValid = NameValidator.isValid((String)testString);
        NameValidatorTests.assertEquals((String)("testNumber: " + testNumber), (boolean)expectedValidity, (boolean)isValid);
    }

    public void testIsValid() {
        Object[][] testees = new Object[][]{{"initial", Boolean.TRUE}, {"foo", Boolean.TRUE}, {"4", Boolean.FALSE}, {"9999", Boolean.FALSE}, {"f9999", Boolean.TRUE}, {"", Boolean.FALSE}, {"got space", Boolean.FALSE}, {" spacebefore", Boolean.FALSE}, {"spaceafter ", Boolean.FALSE}, {"ns:namespace", Boolean.TRUE}, {":funnyns", Boolean.TRUE}, {"endns:", Boolean.TRUE}, {"us_underscore", Boolean.TRUE}, {"_underscore", Boolean.TRUE}, {"underscore_", Boolean.TRUE}, {"averylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersizeaverylongnamethatshouldgooverbuffersize", Boolean.TRUE}};
        int i = 0;
        while (i < testees.length) {
            int j = 0;
            while (j < this.nTrials) {
                this.doTest(i, (String)testees[i][0], (Boolean)testees[i][1]);
                ++j;
            }
            ++i;
        }
    }
}

