/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.jface.resource.*;
import org.eclipse.ui.*;
import org.eclipse.wst.rdb.internal.models.sql.tables.*;


public class TableDataEditorInput implements IEditorInput {

    protected Table table;
    
    public TableDataEditorInput(Table table)
    {
        this.table = table;
    }

    public boolean exists() {
        return table!=null;
    }


    public ImageDescriptor getImageDescriptor() {
        return null;
    }


    public String getName() {
        return table.getName();
    }

    
    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {        
        return table.getSchema().getName() + "." + table.getName(); //$NON-NLS-1$
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Table getTable() {
        return table;
    }
    
    public boolean equals(Object o)
    {
        if (o instanceof TableDataEditorInput)
            return this.table==((TableDataEditorInput)o).table;
        else
            return false;
    }
}
