/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.load;

import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.jobs.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.wst.rdb.data.internal.core.load.*;
import org.eclipse.wst.rdb.internal.models.sql.tables.*;
import org.eclipse.wst.rdb.internal.outputview.*;


public class LoadDataWizard extends Wizard
{

    protected Table table;
    
    protected LoadDataWizardPage page;
    
    public LoadDataWizard(Table table)
    {
        this.table = table;
        setWindowTitle(Messages.getString("LoadDataWizard.LoadData")); //$NON-NLS-1$
    }
    
    public void addPages() {
        page = new LoadDataWizardPage("org.eclipse.wst.rdb.data.ui.loadData"); //$NON-NLS-1$
        addPage(page);
    }

    public boolean performFinish()
    {
        page.saveSettings();
        
        String colDelim = page.getColumnDelimiter();        
        String stringDelim = page.getStringDelimiter();
        String filePath = page.getFilePath();
        boolean replace = page.getReplace();
//        String rowDelim = page.getLocale();
        
        final LoadData load = new LoadData(table, filePath);
        load.setDelims(colDelim, stringDelim);
        load.setReplace(replace);
        
        final OutputItem item = initDbOutputItem();
        
        Job job = new Job(Messages.getString("LoadDataWizard.DataLoading")) { //$NON-NLS-1$
            protected IStatus run(IProgressMonitor monitor) {
                int ret = load.doLoad(item);
                OutputViewAPI.getInstance().updateStatus(item, ret, true);
                return Status.OK_STATUS;
               }
            };
        job.setPriority(Job.SHORT);
        job.schedule();
        
        return true;        
    }
    
    protected void showReport()
    {
        
    }
    
    protected OutputItem initDbOutputItem()
    {
        OutputItem item = OutputViewAPI.getInstance().findOutputItem(getFullyQualifiedName(), OutputItem.ACTION_IMPORT, true);        
        if (item==null) {
            item = new OutputItem(OutputItem.STATUS_IN_PROGRESS, OutputItem.ACTION_IMPORT, table.getName(), getFullyQualifiedName());
            OutputViewAPI.getInstance().addOutputItem(item, true);            
        } else {            
            OutputViewAPI.getInstance().resetOutputItem(item, true);
            OutputViewAPI.getInstance().updateStatus(item,OutputItem.STATUS_IN_PROGRESS, true);            
        }
        return item;
    }
    
    protected String getFullyQualifiedName() {
    	return "\"" + table.getSchema().getName() + "\".\"" + table.getName() + "\""; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    }
    
}
