/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.internal.models.sql.accesscontrol;

import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Privilege</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#isGrantable <em>Grantable</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#getAction <em>Action</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#getGrantor <em>Grantor</em>}</li>
 *   <li>{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#getObject <em>Object</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getPrivilege()
 * @model 
 * @generated
 */
public interface Privilege extends SQLObject{
	/**
	 * Returns the value of the '<em><b>Grantable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Grantable</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Grantable</em>' attribute.
	 * @see #setGrantable(boolean)
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getPrivilege_Grantable()
	 * @model 
	 * @generated
	 */
	boolean isGrantable();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#isGrantable <em>Grantable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Grantable</em>' attribute.
	 * @see #isGrantable()
	 * @generated
	 */
	void setGrantable(boolean value);

	/**
	 * Returns the value of the '<em><b>Action</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Action</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Action</em>' attribute.
	 * @see #setAction(String)
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getPrivilege_Action()
	 * @model 
	 * @generated
	 */
	String getAction();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#getAction <em>Action</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Action</em>' attribute.
	 * @see #getAction()
	 * @generated
	 */
	void setAction(String value);

	/**
	 * Returns the value of the '<em><b>Grantor</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier#getGrantedPrivilege <em>Granted Privilege</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Grantor</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Grantor</em>' reference.
	 * @see #setGrantor(AuthorizationIdentifier)
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getPrivilege_Grantor()
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.AuthorizationIdentifier#getGrantedPrivilege
	 * @model opposite="grantedPrivilege" required="true"
	 * @generated
	 */
	AuthorizationIdentifier getGrantor();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#getGrantor <em>Grantor</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Grantor</em>' reference.
	 * @see #getGrantor()
	 * @generated
	 */
	void setGrantor(AuthorizationIdentifier value);

	/**
	 * Returns the value of the '<em><b>Object</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Object</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Object</em>' reference.
	 * @see #setObject(SQLObject)
	 * @see org.eclipse.wst.rdb.internal.models.sql.accesscontrol.SQLAccessControlPackage#getPrivilege_Object()
	 * @model required="true"
	 * @generated
	 */
	SQLObject getObject();

	/**
	 * Sets the value of the '{@link org.eclipse.wst.rdb.internal.models.sql.accesscontrol.Privilege#getObject <em>Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Object</em>' reference.
	 * @see #getObject()
	 * @generated
	 */
	void setObject(SQLObject value);

} // Privilege
