 /*******************************************************************************
  * Copyright (c) 2005 Versant Corporation and others.
  * All rights reserved. This program and the accompanying materials
  * are made available under the terms of the Eclipse Public License v1.0
  * which accompanies this distribution, and is available at
  * http://www.eclipse.org/legal/epl-v10.html
  * 
  * Contributors:
  *     Versant Corporation - initial API and implementation
  *******************************************************************************/
 package org.eclipse.wst.rdb.internal.mysql.catalog;

import org.eclipse.wst.rdb.internal.models.sql.constraints.impl.PrimaryKeyImpl;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;

import java.sql.Connection;

/**
 * This class is the PrimaryKey implementation
 */
public class MySqlCatalogPrimaryKey extends PrimaryKeyImpl implements
		ICatalogObject {

	private static final long serialVersionUID = 3256441425942951474L;

	public void refresh() {
	}

	public boolean isSystemObject() {
		return false;
	}

	public Connection getConnection() {
		Database database = this.getCatalogDatabase();
		return ((MySqlCatalogDatabase) database).getConnection();
	}

	public Database getCatalogDatabase() {
		return this.getBaseTable().getSchema().getDatabase();
	}

}
