 /*******************************************************************************
  * Copyright (c) 2005 Versant Corporation and others.
  * All rights reserved. This program and the accompanying materials
  * are made available under the terms of the Eclipse Public License v1.0
  * which accompanies this distribution, and is available at
  * http://www.eclipse.org/legal/epl-v10.html
  * 
  * Contributors:
  *     Versant Corporation - initial API and implementation
  *******************************************************************************/
 package org.eclipse.wst.rdb.internal.mysql.catalog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLSchemaPackage;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.SchemaImpl;
import org.eclipse.wst.rdb.internal.mysql.MysqlPlugin;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

/**
 * This class is the Schema implementation, its purpose is to load tables
 */
public class MySqlCatalogSchema extends SchemaImpl implements ICatalogObject {

	private static final long serialVersionUID = 3257567317125903160L;

	private boolean tablesLoaded = false;

	public synchronized void refresh() {
		this.tablesLoaded = false;
		RefreshManager.getInstance().referesh(this);
	}

	public boolean isSystemObject() {
		return false;
	}

	public Connection getConnection() {
		Database database = this.getDatabase();
		return ((MySqlCatalogDatabase) database).getConnection();
	}

	public Database getCatalogDatabase() {
		return this.getDatabase();
	}

	public EList getTables() {
		if (!this.tablesLoaded)
			this.loadTables();
		return this.tables;
	}

	public boolean eIsSet(EStructuralFeature eFeature) {
		int id = eDerivedStructuralFeatureID(eFeature);
		if (id == SQLSchemaPackage.SCHEMA__TABLES) {
			this.getTables();
		} else if (id == SQLSchemaPackage.SCHEMA__ROUTINES) {
			this.getRoutines();
		}
		return super.eIsSet(eFeature);
	}

	/**
	 * Load the table names, we also get the engin type ie. InnoDB ect. of the
	 * table, we can do a chech here to see if there is a identyty column here,
	 * if there is we know to load it later.
	 */
	private synchronized void loadTables() {
		if (this.tablesLoaded)
			return;
		EList tableList = super.getTables();
		tableList.clear();
		Connection connection = this.getConnection();

		boolean deliver = this.eDeliver();
		this.eSetDeliver(false);

		String query = "SHOW TABLE STATUS FROM " + this.getDatabase().getName();
		try {
			Statement s = connection.createStatement();
			ResultSet r = s.executeQuery(query);
			while (r.next()) {
				MySqlCatalogTable table = new MySqlCatalogTable();
				table.setName(r.getString("Name"));
				table.setTableType(r.getString("Type"));
				table.setAutoInc(r.getBoolean("Auto_increment"));
				tableList.add(table);
			}
			this.tablesLoaded = true;
			r.close();
		} catch (Exception e) {
			MysqlPlugin.getDefault().getLog().log(
					new Status(IStatus.ERROR, MysqlPlugin.ID, 0,
							"Could not load the tables for database "
									+ this.getDatabase().getName(), e));
		}

		this.eSetDeliver(deliver);
	}
}
