/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.PlatformUI;


/**
 * Standard action for renaming the selected resource. The resource may be a file, folder or
 * project. An INavigatorSiteEditor will be used to let the user type a new name for the selected
 * resource.
 * <p>
 * This class may be instantiated; it is not intended to be subclassed.
 * </p>
 * <p>
 * This class is experimental and is subject to change.
 * </p>
 * 
 * Derived from org.eclipse.ui.actions.RenameResourceAction
 */
public class RenameResourceAction implements IActionDelegate {
	private org.eclipse.ui.actions.RenameResourceAction renameAction = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if (this.renameAction == null)
			this.renameAction = new org.eclipse.ui.actions.RenameResourceAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
		this.renameAction.run();

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (this.renameAction == null)
			this.renameAction = new org.eclipse.ui.actions.RenameResourceAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());

		this.renameAction.selectionChanged((IStructuredSelection) selection);
	}
}