/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Dec 2, 2003
 * 
 * To change the template for this generated file go to Window>Preferences>Java>Code Generation>Code and Comments
 */
package org.eclipse.wst.common.navigator.internal.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentExtension;
import org.eclipse.wst.common.navigator.internal.provisional.views.INavigatorContentProvider;


/**
 * @author jlanuti
 * 
 * To change the template for this generated type comment go to Window>Preferences>Java>Code
 * Generation>Code and Comments
 */
public class NavigatorGroupContentProvider implements INavigatorContentProvider, IResourceChangeListener, IResourceDeltaVisitor {
	protected boolean groupingEnabled = true;

	protected List cachedGroupList;

	protected Map projectToLastKnownParentMap = new WeakHashMap();
	private Viewer viewer;

	/**
	 * @return Returns the containingExtension.
	 */
	public INavigatorContentExtension getContainingExtension() {
		return null;
	}

	public NavigatorGroupContentProvider() {
		//Default constructor
	}

	/**
	 * default constructor
	 */
	public NavigatorGroupContentProvider(INavigatorContentExtension containingExtension) {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof IWorkspaceRoot) {
			if (!isGroupingEnabled())
				return getAllProjects();
			cachedGroupList = NavigatorGroupActivityHelper.getEnabledGroups();
			return cachedGroupList.toArray();
		} else if (parentElement instanceof NavigatorGroup) {
			NavigatorGroup navGroup = (NavigatorGroup) parentElement;
			IProject[] projects = null;
			if (navGroup.getNatureID() != null && !navGroup.getNatureID().equals(NavigatorGroupExtensionReader.NON_GROUPED_ID))
				projects = getProjectsIfBestNatureID(navGroup.getNatureID(), NavigatorGroupExtensionReader.getInstance().getKnownGroupNatureIDs());
			else
				projects = getNonGroupedProjects();
			updateLastKnownParent(projects, navGroup);
			return projects;
		}
		return new Object[0];
	}

	/**
	 * @return non grouped objects
	 */
	private IProject[] getNonGroupedProjects() {
		List result = new ArrayList();
		List knownGroupNatureIds = NavigatorGroupExtensionReader.getInstance().getKnownGroupNatureIDs();
		IProject[] projects = getAllProjects();
		for (int i = 0; i < projects.length; i++) {
			IProject project = projects[i];
			boolean isGrouped = false;
			for (int j = 0; j < knownGroupNatureIds.size(); j++) {
				String natureID = (String) knownGroupNatureIds.get(j);
				if (isBestNatureForProject(project, natureID, knownGroupNatureIds)) {
					isGrouped = true;
					break;
				}
			}
			if (!isGrouped)
				result.add(project);
		}
		IProject[] resultProjects = new IProject[result.size()];
		result.toArray(resultProjects);
		return resultProjects;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) {
		if (element instanceof IProject) {
			if (isGroupingEnabled()) {
				IProject project = (IProject) element;
				if (getProjectToLastKnownParentMap().get(project) != null)
					return getProjectToLastKnownParentMap().get(project);
				NavigatorGroup parent = getBestNavigatorGroupParent(project);
				getProjectToLastKnownParentMap().put(project, parent);
				return parent;
			}
			return ResourcesPlugin.getWorkspace().getRoot();
		}
		return null;
	}

	/**
	 * @param project
	 * @return
	 */
	public NavigatorGroup getBestNavigatorGroupParent(IProject project) {
		List knownGroupNatureIds = NavigatorGroupExtensionReader.getInstance().getKnownGroupNatureIDs();
		String bestNature = getBestNatureForProject(project, knownGroupNatureIds);
		if (bestNature != null)
			return NavigatorGroupExtensionReader.getInstance().getNavigatorGroup(bestNature);
		return NavigatorGroupExtensionReader.getInstance().getDefaultNavigatorGroup();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) {
		if (element instanceof IProject)
			return ((IProject) element).isOpen();
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.navigator.internal.views.navigator.INavigatorContentProvider#init(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
		viewer = aViewer;
		IWorkspace oldWorkspace = null;
		IWorkspace newWorkspace = null;

		if (oldInput instanceof IWorkspace) {
			oldWorkspace = (IWorkspace) oldInput;
		} else if (oldInput instanceof IContainer) {
			oldWorkspace = ((IContainer) oldInput).getWorkspace();
		}

		if (newInput instanceof IWorkspace) {
			newWorkspace = (IWorkspace) newInput;
		} else if (newInput instanceof IContainer) {
			newWorkspace = ((IContainer) newInput).getWorkspace();
		}

		if (oldWorkspace != newWorkspace) {
			if (oldWorkspace != null) {
				oldWorkspace.removeResourceChangeListener(this);
			}
			if (newWorkspace != null) {
				newWorkspace.addResourceChangeListener(this, IResourceChangeEvent.POST_CHANGE);
			}
		}
	}

	private boolean isBestNatureForProject(IProject project, String natureID, List natureList) {
		String[] projectNatures = null;
		try {
			projectNatures = project.getDescription().getNatureIds();
		} catch (Exception e1) {
			//Ignore
		}
		if (projectNatures == null || projectNatures.length == 0)
			return false;
		for (int i = 0; i < projectNatures.length; i++) {
			if (projectNatures[i].equals(natureID))
				return true;
			else if (natureList.contains(projectNatures[i]))
				break;
		}
		return false;
	}

	private String getBestNatureForProject(IProject project, List natureList) {
		String[] projectNatures = null;
		try {
			projectNatures = project.getDescription().getNatureIds();
		} catch (Exception e1) {
			return null;
		}
		if (projectNatures == null && projectNatures.length == 0)
			return null;
		for (int i = 0; i < projectNatures.length; i++) {
			if (natureList.contains(projectNatures[i]))
				return projectNatures[i];
		}
		return null;
	}

	private IProject[] getProjectsIfBestNatureID(String natureID, List natureList) {
		List result = new ArrayList();
		IProject[] projects = getAllProjects();
		for (int i = 0; i < projects.length; i++) {
			if (isBestNatureForProject(projects[i], natureID, natureList))
				result.add(projects[i]);
		}
		IProject[] resultProjects = new IProject[result.size()];
		result.toArray(resultProjects);
		return resultProjects;
	}

	private IProject[] getAllProjects() {
		return ResourcesPlugin.getWorkspace().getRoot().getProjects();
	}

	/**
	 * @return Returns the groupingEnabled.
	 */
	public boolean isGroupingEnabled() {
		return this.groupingEnabled;
	}

	/**
	 * @param groupingEnabled
	 *            The groupingEnabled to set.
	 */
	public void setGroupingEnabled(boolean groupingEnabled) {
		this.groupingEnabled = groupingEnabled;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
		if (viewer != null) {
			IWorkspace workspace = null;
			Object obj = viewer.getInput();
			if (obj instanceof IWorkspace) {
				workspace = (IWorkspace) obj;
			} else if (obj instanceof IContainer) {
				workspace = ((IContainer) obj).getWorkspace();
			}
			if (workspace != null) {
				workspace.removeResourceChangeListener(this);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	public List getCachedGroupList() {
		return cachedGroupList;
	}

	public void setCachedGroupList(List cachedGroupList) {
		this.cachedGroupList = cachedGroupList;
	}

	/**
	 * @return Returns the projectToLastKnownParentMap.
	 */
	protected Map getProjectToLastKnownParentMap() {
		return projectToLastKnownParentMap;
	}

	/**
	 * @param project
	 */
	public void updateLastKnownParent(IProject project) {
		updateLastKnownParent(project, getBestNavigatorGroupParent(project));

	}

	/**
	 * @param project
	 * @param bestNavigatorGroupParent
	 */
	private void updateLastKnownParent(IProject project, NavigatorGroup bestNavigatorGroupParent) {
		getProjectToLastKnownParentMap().put(project, bestNavigatorGroupParent);
	}

	/**
	 * @param projects
	 * @param navGroup
	 */
	private void updateLastKnownParent(IProject[] projects, NavigatorGroup navGroup) {
		for (int i = 0; i < projects.length; i++)
			updateLastKnownParent(projects[i], navGroup);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.resources.IResourceChangeListener#resourceChanged(org.eclipse.core.resources.IResourceChangeEvent)
	 */
	public void resourceChanged(final IResourceChangeEvent anEvent) {
		final IResourceDelta delta = anEvent.getDelta();
		if (delta != null) {
			try {
				delta.accept(NavigatorGroupContentProvider.this);
			} catch (CoreException e) {
				WorkbenchNavigatorPlugin.log(e.getMessage(), new Status(IStatus.WARNING, WorkbenchNavigatorPlugin.PLUGIN_ID, 0, e.getLocalizedMessage(), e));
			}
		}
	}



	public void processDelta(IResourceDelta aDelta, IProject aProject) {
		if (viewer instanceof AbstractTreeViewer) {
			AbstractTreeViewer treeViewer = (AbstractTreeViewer) viewer;
			treeViewer.getControl().setRedraw(false);
			try {
				switch (aDelta.getKind()) {
					case IResourceDelta.REMOVED :
						treeViewer.remove(aProject);
						break;
					case IResourceDelta.ADDED : {
						treeViewer.add(getParent(aProject), aProject);
						break;
					}
					case IResourceDelta.CHANGED :
						boolean natureMayHaveChanged = ((aDelta.getFlags() & IResourceDelta.DESCRIPTION) != 0) && ((aDelta.getFlags() & IResourceDelta.MARKERS) == 0);
						boolean projectOpenStateChanged = ((aDelta.getFlags() & IResourceDelta.OPEN) != 0);
						if (natureMayHaveChanged || projectOpenStateChanged) {

							// should only happen if the cached value does not
							// match the correct value
							Object oldParent = getParent(aProject);
							Object newParent = getBestNavigatorGroupParent(aProject);
							if (oldParent != newParent) {
								updateLastKnownParent(aProject);
								treeViewer.remove(aProject);
								treeViewer.add(newParent, aProject);
							}
							treeViewer.refresh(aProject, true);

						}
						break;
				}
			} finally {
				treeViewer.getControl().setRedraw(true);
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.resources.IResourceDeltaVisitor#visit(org.eclipse.core.resources.IResourceDelta)
	 */
	public boolean visit(IResourceDelta aDelta) throws CoreException {
		final IResourceDelta finalDelta = aDelta;
		IResource resource = finalDelta.getResource();
		if (resource != null) {
			if (resource.getType() == IResource.PROJECT) {
				final IProject project = (IProject) resource;
				if (Display.getCurrent() != null) {
					processDelta(finalDelta, project);
				} else {
					/* Create and schedule a UI Job to update the Navigator Content Viewer */
					new UIJob("Update the Navigator Content Viewer Job") { //$NON-NLS-1$
						public IStatus runInUIThread(IProgressMonitor monitor) {
							processDelta(finalDelta, project);
							return Status.OK_STATUS;
						}
					}.schedule();
				}
				return false;
			}
		}
		return true;
	}


	//	public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
	//		if (provider.isGroupingEnabled()) {
	//			List currentList = provider.getCachedGroupList();
	//			List enabledList = NavigatorGroupActivityHelper.getEnabledGroups();
	//			List removeList = new ArrayList();
	//			List addList = new ArrayList();
	//			if(currentList == null)
	//				return;
	//			Iterator iterator = currentList.iterator();
	//			Object next = null;
	//			while (iterator.hasNext()) {
	//				next = iterator.next();
	//				if (!enabledList.contains(next)) {
	//					removeList.add(next);
	//				}
	//			}
	//			iterator = enabledList.iterator();
	//			while (iterator.hasNext()) {
	//				next = iterator.next();
	//				if (!currentList.contains(next)) {
	//					addList.add(next);
	//				}
	//			}
	//			if (removeList.size() > 0) {
	//				getExtensionSite().notifyElementsRemoved(this, removeList.toArray());
	//			}
	//			if (addList.size() > 0) {
	//				Object root = ResourcesPlugin.getWorkspace().getRoot();
	//				getExtensionSite().notifyElementsAdded(this, root, addList.toArray());
	//			}
	//			List cacheList = new ArrayList();
	//			cacheList.addAll(currentList);
	//			cacheList.addAll(addList);
	//			cacheList.removeAll(removeList);
	//			provider.setCachedGroupList(cacheList);
	//		}
	//	}


}