/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.fe.internal.ui.wizards;

import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.rdb.fe.internal.ui.util.ResourceLoader;


/**
 * @author ledunnel
 */
public class FESummaryWizardPage extends WizardPage {

    private Table summaryTable;
    
    private FESummaryProperty[] properties;
    
    private boolean visible = false;
    
    public FESummaryWizardPage(String name) {
        super(name);

        setTitle(ResourceLoader.INSTANCE
                .queryString("FEWizard.SummaryPage.title"));  //$NON-NLS-1$
        setDescription(ResourceLoader.INSTANCE
                .queryString("FEWizard.SummaryPage.description"));  //$NON-NLS-1$
    }

    public void createControl(Composite parent) {

        Composite composite = new Composite(parent, SWT.NONE);

        GridLayout layout = new GridLayout();
        composite.setLayout(layout);

        summaryTable = new Table(composite, SWT.BORDER | SWT.FULL_SELECTION
                | SWT.V_SCROLL | SWT.H_SCROLL);
        GridData gd = new GridData();
        gd.widthHint = 1;
        gd.heightHint = 1;
        gd.horizontalAlignment = GridData.FILL;
        gd.verticalAlignment = GridData.FILL;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        summaryTable.setLayoutData(gd);
        summaryTable.setLayout(layout);
        summaryTable.setLinesVisible(true);
        summaryTable.setHeaderVisible(true);
        summaryTable.addListener(SWT.Resize, new Listener() {
            public void handleEvent(Event e) {
                int weights[] = new int[] { 2, 4 };
                int weightsum = 0;
                for (int i = 0; i < weights.length; i++) {
                    weightsum += weights[i];
                }
                TableColumn[] cols = summaryTable.getColumns();
                int count = java.lang.Math.min(weights.length, cols.length);
                int tablewidth = summaryTable.getSize().x;
                for (int i = 0; i < count; i++) {
                    cols[i].setWidth(tablewidth * weights[i] / weightsum);
                }
            }
        });
        
        // Initialize Table
        TableLayout tblLayout = new TableLayout();
        tblLayout.addColumnData(new ColumnWeightData(1, true));
        TableColumn colSetting = new TableColumn(summaryTable, SWT.NULL);
        colSetting.setText(ResourceLoader.INSTANCE
                .queryString("FEWizard.SummaryPage.settingColumnHeader"));  //$NON-NLS-1$
        tblLayout.addColumnData(new ColumnWeightData(3, true));
        TableColumn colValue = new TableColumn(summaryTable, SWT.NULL);
        colValue.setText(ResourceLoader.INSTANCE
                .queryString("FEWizard.SummaryPage.valueColumnHeader"));  //$NON-NLS-1$
        

        setControl(composite);
    }
    

    
    public void setProperties(FESummaryProperty[] properties){
        this.properties = properties;
    }
    
	public void setVisible(boolean visible){
	    this.visible = visible;
		if(visible)
			loadProperties();
		super.setVisible(visible);
	}
	
	public boolean isVisible(){
	    return this.visible;
	}
	
	private void loadProperties(){
	    summaryTable.removeAll();
		if (properties != null){
			int propertyCount =  properties.length;
			for( int index = 0; index < propertyCount; index++){
				new TableItem(summaryTable,
						SWT.NONE).setText(new String[] { properties[index].getPropertyName(),
						properties[index].getValue()});
			}
		}	    
	}
}