/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.server.geronimo.ui.internal;

import java.io.InputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.geronimo.core.internal.model.WebAppDeploymentPlan;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public class DPEditor extends EditorPart {
	
	protected FormToolkit toolkit;
	protected Text configId;
	protected Text parentId;
	protected Text contextRoot;
	protected Button cpClassLoaderWebAppFirst;
	protected Button cpClassLoaderServerFirst;
	
	protected WebAppDeploymentPlan plan;
	protected boolean dirty;

	public void doSave(IProgressMonitor monitor) {
		if (isDirty()) {
			InputStream is = null;
			try {
				IEditorInput input = getEditorInput();
				if (input instanceof IFileEditorInput) {
					IFileEditorInput fei = (IFileEditorInput) input;

					is = plan.saveToStream();
					fei.getFile().setContents(is, false, false, null);
					setDirty(false);
				}
			} catch (Exception e) {
				Trace.trace(Trace.SEVERE, "Error saving", e);
			} finally {
				try {
					if (is != null)
						is.close();
				} catch (Exception e) {
					// do nothing
				}
			}
		}
	}

	public void doSaveAs() {
		// ignore
	}

	public void init(IEditorSite site, IEditorInput input)
			throws PartInitException {
		setSite(site);
		setInput(input);

		if (input instanceof IFileEditorInput) {
			IFileEditorInput fei = (IFileEditorInput) input;
			IFile file = fei.getFile();

			try {
				InputStream is = file.getContents();
				plan = new WebAppDeploymentPlan(is);
			} catch (Exception x) {
				throw new PartInitException(Messages.errorCouldNotOpenFile);
			}
		}
	}

	public boolean isDirty() {
		return dirty;
	}

	public boolean isSaveAsAllowed() {
		return false;
	}

	public void createPartControl(Composite parent) {
		toolkit = new FormToolkit(parent.getDisplay());

		ScrolledForm form = toolkit.createScrolledForm(parent);
		form.setText(Messages.editorTitle);
		form.getBody().setLayout(new GridLayout());

//		Composite columnComp = toolkit.createComposite(form.getBody());
//		GridLayout layout = new GridLayout();
//		layout.numColumns = 1;
//		// layout.marginHeight = 10;
//		// layout.marginWidth = 10;
//		layout.verticalSpacing = 0;
//		layout.horizontalSpacing = 10;
//		columnComp.setLayout(layout);
//		columnComp.setLayoutData(new GridData(GridData.FILL_HORIZONTAL
//				| GridData.VERTICAL_ALIGN_FILL));

		createControls(form.getBody());
		
		DPEditorResRef resRefSection=new DPEditorResRef(this, toolkit);
		resRefSection.createControls(form.getBody());

		DPEditorResEnvRef resEnvRefSection=new DPEditorResEnvRef(this, toolkit);
		resEnvRefSection.createControls(form.getBody());
		
		form.reflow(true);
	}

	private void createControls(Composite columnComp) {
		Section section = toolkit.createSection(columnComp,
				ExpandableComposite.TWISTIE | ExpandableComposite.EXPANDED
						| ExpandableComposite.TITLE_BAR | Section.DESCRIPTION
						| ExpandableComposite.FOCUS_TITLE);
		section.setText(Messages.editorSectionGeneralTitle);
		section.setDescription(Messages.editorSectionGeneralDescription);
		section.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));

		Composite composite = toolkit.createComposite(section);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 5;
		layout.marginWidth = 10;
		layout.verticalSpacing = 5;
		layout.horizontalSpacing = 15;
		composite.setLayout(layout);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		// toolkit.paintBordersFor(composite);
		section.setClient(composite);

		// ------- Label and text field for the config Id -------
		createLabel(composite, Messages.editorConfigId);
		
		configId = toolkit
				.createText(composite, plan.getConfigId(), SWT.BORDER);
		configId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		configId.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				plan.setConfigId(configId.getText());
				setDirty(true);
			}
		});

		// ------- Label and text field for the parent Id -------
		createLabel(composite, Messages.editorParentId);
		
		parentId = toolkit
				.createText(composite, plan.getParentId(), SWT.BORDER);
		parentId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		parentId.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				plan.setParentId(parentId.getText());
				setDirty(true);
			}
		});

		// ------- Label and text field for the context root -------
		createLabel(composite, Messages.editorContextRoot);
		
		contextRoot = toolkit.createText(composite, plan.getContextRoot(),
				SWT.BORDER);
		contextRoot.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
		contextRoot.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				plan.setContextRoot(contextRoot.getText());
				setDirty(true);
			}
		});

		// ------- Label and check box for the Context Priority Classloader
		// -------
		Label classLoaderLabel = toolkit.createLabel(composite,
				Messages.editorClassloader);
		GridData data = new GridData(SWT.LEFT, SWT.CENTER, false, false);
		data.horizontalSpan = 2;
		classLoaderLabel.setLayoutData(data);
		
		cpClassLoaderServerFirst = toolkit.createButton(composite,
				Messages.editorClassloaderServer, SWT.RADIO);
		data = new GridData(SWT.FILL, SWT.CENTER, false, false);
		data.horizontalSpan = 2;
		cpClassLoaderServerFirst.setLayoutData(data);
		cpClassLoaderServerFirst.setSelection(!plan
				.getContextPriorityClassloader());

		cpClassLoaderWebAppFirst = toolkit.createButton(composite,
				Messages.editorClassloaderWebApp, SWT.RADIO);
		data = new GridData(SWT.FILL, SWT.CENTER, false, false);
		data.horizontalSpan = 2;
		cpClassLoaderWebAppFirst.setLayoutData(data);
		cpClassLoaderWebAppFirst.setSelection(plan
				.getContextPriorityClassloader());

		cpClassLoaderWebAppFirst.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				plan.setContextPriorityClassloader(cpClassLoaderWebAppFirst
						.getSelection());
				setDirty(true);
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				// Not invoked
			}
		});
	}
	
	protected Label createLabel(Composite parent, String text) {
		Label label = toolkit.createLabel(parent, text);
		label.setForeground(toolkit.getColors().getColor(
				FormColors.TITLE));
		label.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
		return label;
	}

	/**
	 * Dispose of the editor.
	 */
	public void dispose() {
		super.dispose();

		if (toolkit != null)
			toolkit.dispose();
	}

	protected void setDirty(boolean dirty) {
		if (dirty == this.dirty)
			return;
		this.dirty = dirty;
		firePropertyChange(PROP_DIRTY);
	}

	public void setFocus() {
		// ignore
	}

	public WebAppDeploymentPlan getPlan() {
		return plan;
	}
}