/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.wst.common.navigator.internal.provisional.views;

import java.util.Comparator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;

/**
 * <p>
 * This interface defines an extension to an instance of the Common Navigator. Clients are
 * discouraged from using this class as it will likely be removed soon.
 * </p>
 * <p>
 * This interface is experimental and subject to change.
 * </p>
 */
public interface INavigatorContentExtension extends IAdaptable {


	/**
	 * Returns the content provider that supplies the elements for this Navigator extension.
	 */
	public INavigatorContentProvider getContentProvider();

	/**
	 * Returns the label provider which supplies labels for the elements supplied by this Navigator
	 * extension.
	 * 
	 * @return the label provider which supplies labels for this extension's content
	 */
	public ICommonLabelProvider getLabelProvider();

	/**
	 * Initializes the navigator extension, passing its site object, which is the interface to the
	 * containing Navigator view.
	 * 
	 * @param site
	 *            the navigator extension site which provides access to the Navigator.
	 */
	public void init(NavigatorContentDescriptor aDescriptor, NavigatorContentService aContentService);

	/**
	 * Allows implementors to dispose of any allocated resources. Called when the NavigatorViewer
	 * that was using the extension is disposed.
	 */
	public void dispose();

	public Comparator getComparator();

}