/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.navigator.internal.views;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigator;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.actions.CollapseAllAction;
import org.eclipse.wst.common.navigator.internal.views.actions.LinkEditorAction;
import org.eclipse.wst.common.navigator.internal.views.filters.SelectFiltersAction;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class CommonNavigatorActionGroup extends ActionGroup {

	private LinkEditorAction toggleLinkingAction;
	private CollapseAllAction collapseAllAction;
	private SelectFiltersAction selectFiltersAction;
	private final CommonViewer commonViewer;
	private CommonNavigator commonNavigator;

	/**
	 *  
	 */
	public CommonNavigatorActionGroup(CommonNavigator aNavigator, CommonViewer aViewer) {
		super();
		commonNavigator = aNavigator;
		commonViewer = aViewer;
		makeActions();
	}

	/**
	 * Returns the image descriptor with the given relative path.
	 */
	protected final ImageDescriptor getImageDescriptor(String relativePath) {
		String iconPath = "icons/full/"; //$NON-NLS-1$
		try {
			NavigatorPlugin plugin = NavigatorPlugin.getDefault();
			URL installURL = plugin.getDescriptor().getInstallURL();
			URL url = new URL(installURL, iconPath + relativePath);
			return ImageDescriptor.createFromURL(url);
		} catch (MalformedURLException e) {
			// should not happen
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}

	/**
	 *  
	 */
	private void makeActions() {

		toggleLinkingAction = new LinkEditorAction(commonNavigator, commonViewer);
		ImageDescriptor syncIcon = getImageDescriptor("elcl16/synced.gif"); //$NON-NLS-1$
		toggleLinkingAction.setImageDescriptor(syncIcon);
		toggleLinkingAction.setHoverImageDescriptor(syncIcon);

		collapseAllAction = new CollapseAllAction(commonViewer);
		ImageDescriptor collapseAllIcon = getImageDescriptor("elcl16/collapseall.gif"); //$NON-NLS-1$
		collapseAllAction.setImageDescriptor(collapseAllIcon);
		collapseAllAction.setHoverImageDescriptor(collapseAllIcon);

		selectFiltersAction = new SelectFiltersAction(commonViewer);
		ImageDescriptor selectFiltersIcon = getImageDescriptor("elcl16/filter_ps.gif"); //$NON-NLS-1$
		selectFiltersAction.setImageDescriptor(selectFiltersIcon);
		selectFiltersAction.setHoverImageDescriptor(selectFiltersIcon);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.actions.ActionGroup#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public void fillActionBars(IActionBars theActionBars) {
		IMenuManager menu = theActionBars.getMenuManager();

		menu.add(selectFiltersAction);
		menu.add(toggleLinkingAction);

		theActionBars.getToolBarManager().add(collapseAllAction);
		theActionBars.getToolBarManager().add(toggleLinkingAction);

		theActionBars.updateActionBars();
	}

}