/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.extensions;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public class EMFExpression {

	private static final String PACKAGE = "package"; //$NON-NLS-1$
	private static final String ATT_URI = "uri"; //$NON-NLS-1$

	private final IConfigurationElement expression;
	private final Set packageURIs;

	/**
	 * 
	 */
	public EMFExpression(IConfigurationElement aConfigElement) {
		super();
		expression = aConfigElement;
		packageURIs = new HashSet();
		init();
	}

	/**
	 * 
	 */
	private void init() {
		String uri = null;
		IConfigurationElement[] packages = expression.getChildren(PACKAGE);
		for (int i = 0; i < packages.length; i++) {
			uri = packages[i].getAttribute(ATT_URI);
			if (uri != null)
				packageURIs.add(uri);
		}

	}

	public boolean isEnabledFor(Object anElement) {
		if (anElement instanceof EObject)
			return isEnabledFor((EObject) anElement);
		else if (anElement instanceof ItemProvider) 
			return isEnabledFor(findTarget( (ItemProvider) anElement));	 
		else if(anElement instanceof IWrapperItemProvider)
			if(((IWrapperItemProvider)anElement).getOwner() instanceof EObject)
				return isEnabledFor((EObject) ((IWrapperItemProvider)anElement).getOwner());
		return false;
	}

	public boolean isEnabledFor(IStructuredSelection aSelection) {
		if (aSelection == null || aSelection.isEmpty())
			return false;
		Object element = null;
		for (Iterator selItr = aSelection.iterator(); selItr.hasNext();) {
			element = selItr.next();
			if (!isEnabledFor(element))
				return false;
		}
		return true;
	}

	public boolean isEnabledFor(EObject anElement) {
		if (anElement != null)
			return packageURIs.contains(anElement.eClass().getEPackage().getNsURI());
		return false;
	}
	
	private EObject findTarget(ItemProvider anItemProvider) {
		ItemProvider parent = null;
		
		if(anItemProvider.getParent() == null || anItemProvider.getParent() == anItemProvider)
			return null;
		if(anItemProvider.getParent() instanceof EObject)
			return (EObject) anItemProvider.getParent();
		if(anItemProvider.getParent() instanceof Adapter)
			return findTarget((Adapter)anItemProvider.getParent());
		if(anItemProvider.getParent() instanceof ItemProvider)
			return findTarget((ItemProvider)anItemProvider.getParent());
		return null;
	}
	
	private EObject findTarget(Adapter anAdapter) {
		if(anAdapter != null && anAdapter.getTarget() instanceof EObject)
			return (EObject) anAdapter.getTarget();
		return null;		
	}

}