/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on May 11, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.jst.common.navigator.internal.actions;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jdt.internal.ui.refactoring.reorg.CopyToClipboardAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CutAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.DeleteAction;
import org.eclipse.jdt.internal.ui.refactoring.reorg.PasteAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.IWorkbenchActionDefinitionIds;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.IActionWTPOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.PasteActionOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.operation.extensionui.WTPOperationDataModelUICreator;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperationDataModel;



/**
 * @author mdelder
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java -
 * Code Generation - Code and Comments
 */
public class JavaEditOperationPopulator implements WTPOperationDataModelUICreator {

	public static final String CUT_ID = "org.eclipse.wst.common.generic.Cut"; //$NON-NLS-1$

	public static final String COPY_ID = "org.eclipse.wst.common.generic.Copy"; //$NON-NLS-1$

	public static final String PASTE_ID = "org.eclipse.wst.common.generic.Paste"; //$NON-NLS-1$

	public static final String DELETE_ID = "org.eclipse.wst.common.generic.Delete"; //$NON-NLS-1$

	public static final String RENAME_ID = "org.eclipse.wst.common.generic.Rename"; //$NON-NLS-1$

	private Map javaActionsBySite;

	/**
	 *  
	 */
	public JavaEditOperationPopulator() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.wst.common.frameworks.internal.operation.extension.ui.WTPOperationDataModelUICreator#createDataModel(java.lang.String,
	 *      java.lang.String, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public WTPOperationDataModel createDataModel(String extendedOperationId, String operationClass, IStructuredSelection selection, IWorkbenchSite site) {
		if (site == null)
			return null;
		JavaActions actions = getActions(site);

		WTPOperationDataModel dataModel = null;
		if (CUT_ID.equals(extendedOperationId))
			dataModel = IActionWTPOperationDataModel.createDataModel(actions.cutAction, selection, site.getSelectionProvider(), site.getShell());
		if (COPY_ID.equals(extendedOperationId))
			dataModel = IActionWTPOperationDataModel.createDataModel(actions.copyAction, selection, site.getSelectionProvider(), site.getShell());
		if (PASTE_ID.equals(extendedOperationId))
			dataModel = PasteActionOperationDataModel.createDataModel(actions.pasteAction, selection, site.getSelectionProvider(), site.getShell());
		if (DELETE_ID.equals(extendedOperationId))
			dataModel = IActionWTPOperationDataModel.createDataModel(actions.deleteAction, selection, site.getSelectionProvider(), site.getShell());
		return dataModel;
	}

	/**
	 * @param site
	 * @return
	 */
	protected JavaActions getActions(IWorkbenchSite site) {
		JavaActions actions = (JavaActions) getJavaActionsBySite().get(site);
		if (actions == null)
			getJavaActionsBySite().put(site, (actions = new JavaActions(site)));
		return actions;
	}

	/**
	 * @return Returns the javaActionsBySite.
	 */
	protected Map getJavaActionsBySite() {
		if (javaActionsBySite == null)
			javaActionsBySite = new HashMap();
		return javaActionsBySite;
	}

	public class JavaActions {

		private IWorkbenchSite fSite;
		private Clipboard fClipboard;

		SelectionDispatchAction deleteAction;
		SelectionDispatchAction copyAction;
		SelectionDispatchAction pasteAction;
		SelectionDispatchAction cutAction;


		public JavaActions(IWorkbenchSite site) {
			fSite = site;
			fClipboard = new Clipboard(site.getShell().getDisplay());

			pasteAction = new PasteAction(fSite, fClipboard);
			pasteAction.setActionDefinitionId(IWorkbenchActionDefinitionIds.PASTE);

			copyAction = new CopyToClipboardAction(fSite, fClipboard, pasteAction);
			copyAction.setActionDefinitionId(IWorkbenchActionDefinitionIds.COPY);

			cutAction = new CutAction(fSite, fClipboard, pasteAction);
			cutAction.setActionDefinitionId(IWorkbenchActionDefinitionIds.CUT);

			deleteAction = new DeleteAction(fSite);
			deleteAction.setActionDefinitionId(IWorkbenchActionDefinitionIds.DELETE);

		}

		/*
		 * @see ActionGroup#dispose()
		 */
		public void dispose() {
			if (fClipboard != null) {
				fClipboard.dispose();
				fClipboard = null;
			}
		}

	}

}